/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.netty.handler.common;

import com.linkedin.r2.netty.common.ChannelPipelineEvent;
import com.linkedin.r2.netty.common.NettyChannelAttributes;
import com.linkedin.r2.netty.common.StreamingTimeout;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.concurrent.ScheduledFuture;

public class CancelTimeoutHandler
extends ChannelInboundHandlerAdapter {
    public void channelInactive(ChannelHandlerContext ctx) {
        this.tryCancelTimeout(ctx);
        ctx.fireChannelInactive();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.tryCancelTimeout(ctx);
        ctx.fireExceptionCaught(cause);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (ChannelPipelineEvent.RESPONSE_COMPLETE == evt) {
            this.tryCancelTimeout(ctx);
        }
        ctx.fireUserEventTriggered(evt);
    }

    private void tryCancelTimeout(ChannelHandlerContext ctx) {
        StreamingTimeout streamTimeout;
        ScheduledFuture timeout = (ScheduledFuture)ctx.channel().attr(NettyChannelAttributes.TIMEOUT_FUTURE).getAndSet(null);
        if (timeout != null && !timeout.isDone()) {
            timeout.cancel(false);
        }
        if ((streamTimeout = (StreamingTimeout)ctx.channel().attr(NettyChannelAttributes.STREAMING_TIMEOUT_FUTURE).getAndSet(null)) != null) {
            streamTimeout.cancel();
        }
    }
}

