/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.netty.handler.common;

import com.linkedin.r2.netty.common.NettyChannelAttributes;
import com.linkedin.r2.transport.http.client.common.ssl.SslSessionNotTrustedException;
import com.linkedin.r2.transport.http.client.common.ssl.SslSessionValidator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.ssl.SslHandler;

public class CertificateHandler
extends ChannelOutboundHandlerAdapter {
    private final SslHandler _sslHandler;
    private SslSessionValidator _cachedSessionValidator;
    public static final String PIPELINE_CERTIFICATE_HANDLER = "CertificateHandler";

    public CertificateHandler(SslHandler sslHandler) {
        this._sslHandler = sslHandler;
        this._cachedSessionValidator = null;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        this._sslHandler.handshakeFuture().addListener(future -> {
            if (!future.isSuccess()) {
                return;
            }
            SslSessionValidator sslSessionValidator = (SslSessionValidator)ctx.channel().attr(NettyChannelAttributes.SSL_SESSION_VALIDATOR).getAndSet(null);
            if (sslSessionValidator != null && !sslSessionValidator.equals(this._cachedSessionValidator)) {
                this._cachedSessionValidator = sslSessionValidator;
                try {
                    sslSessionValidator.validatePeerSession(this._sslHandler.engine().getSession());
                }
                catch (SslSessionNotTrustedException e) {
                    ctx.fireExceptionCaught((Throwable)e);
                    return;
                }
            }
            ctx.write(msg, promise);
        });
    }

    public void flush(ChannelHandlerContext ctx) {
        this._sslHandler.handshakeFuture().addListener(future -> ctx.flush());
    }
}

