/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.netty.handler.common;

import com.linkedin.r2.netty.common.ChannelPipelineEvent;
import com.linkedin.r2.netty.common.NettyChannelAttributes;
import com.linkedin.r2.netty.common.ShutdownTimeoutException;
import com.linkedin.r2.transport.http.client.AsyncPool;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;

public class ChannelLifecycleHandler
extends ChannelInboundHandlerAdapter {
    private final boolean _recycle;

    public ChannelLifecycleHandler(boolean recycle) {
        this._recycle = recycle;
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        this.tryDisposeChannel(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (this.isChannelRecyclableException(cause)) {
            this.tryReturnChannel(ctx);
        } else {
            this.tryDisposeChannel(ctx);
        }
    }

    private boolean isChannelRecyclableException(Throwable cause) {
        return this._recycle && cause instanceof ShutdownTimeoutException;
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (ChannelPipelineEvent.RESPONSE_COMPLETE == evt) {
            if (this._recycle) {
                this.tryReturnChannel(ctx);
            } else {
                this.tryDisposeChannel(ctx);
            }
        }
        ctx.fireUserEventTriggered(evt);
    }

    private void tryDisposeChannel(ChannelHandlerContext ctx) {
        AsyncPool pool = (AsyncPool)ctx.channel().attr(NettyChannelAttributes.CHANNEL_POOL).getAndSet(null);
        if (pool != null) {
            pool.dispose((Object)ctx.channel());
        }
    }

    private void tryReturnChannel(ChannelHandlerContext ctx) {
        AsyncPool pool = (AsyncPool)ctx.channel().attr(NettyChannelAttributes.CHANNEL_POOL).getAndSet(null);
        if (pool != null) {
            pool.put((Object)ctx.channel());
        }
    }
}

