/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.netty.handler.common;

import com.linkedin.r2.message.Request;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.stream.StreamRequest;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import java.net.URI;

public class SchemeHandler
extends ChannelOutboundHandlerAdapter {
    private final String _scheme;

    public SchemeHandler(String scheme) {
        this._scheme = scheme;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        Request request;
        URI uri;
        String scheme;
        if ((msg instanceof StreamRequest || msg instanceof RestRequest) && !(scheme = (uri = (request = (Request)msg).getURI()).getScheme()).equalsIgnoreCase(this._scheme)) {
            ctx.fireExceptionCaught((Throwable)new IllegalStateException(String.format("Cannot switch scheme from %s to %s, remote=%s", this._scheme, scheme, ctx.channel().remoteAddress())));
            return;
        }
        ctx.write(msg, promise);
    }
}

