/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.netty.handler.common;

import com.linkedin.r2.netty.common.SslHandlerUtil;
import com.linkedin.r2.netty.handler.common.CertificateHandler;
import com.linkedin.r2.netty.handler.common.SslHandshakeTimingHandler;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.Future;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;

public class SessionResumptionSslHandler
extends ChannelOutboundHandlerAdapter {
    public static final String PIPELINE_SESSION_RESUMPTION_HANDLER = "SessionResumptionSslHandler";
    public static final AttributeKey<SessionResumptionSslHandler> CHANNEL_SESSION_RESUMPTION_HANDLER = AttributeKey.valueOf((String)"sslSessionResumptionHandler");
    private final SslHandlerGenerator _hostPortToSslHandler;
    private final int _sslHandShakeTimeout;

    public SessionResumptionSslHandler(SslContext sslContext, boolean enableResumption, int sslHandShakeTimeout) {
        this._sslHandShakeTimeout = sslHandShakeTimeout;
        this._hostPortToSslHandler = enableResumption ? (ctx, host, port) -> sslContext.newHandler(ctx.alloc(), host, port) : (ctx, host, port) -> sslContext.newHandler(ctx.alloc());
    }

    public SessionResumptionSslHandler(SSLContext sslContext, SSLParameters sslParameters, boolean enableResumption, int sslHandShakeTimeout) {
        this._sslHandShakeTimeout = sslHandShakeTimeout;
        this._hostPortToSslHandler = enableResumption ? (ctx, host, port) -> SslHandlerUtil.getClientSslHandler(sslContext, sslParameters, host, port) : (ctx, host, port) -> SslHandlerUtil.getSslHandler(sslContext, sslParameters, true);
    }

    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        InetSocketAddress address = (InetSocketAddress)remoteAddress;
        SslHandler sslHandler = this._hostPortToSslHandler.create(ctx, address.getHostName(), address.getPort());
        sslHandler.setHandshakeTimeout((long)this._sslHandShakeTimeout, TimeUnit.MILLISECONDS);
        ctx.pipeline().addAfter(PIPELINE_SESSION_RESUMPTION_HANDLER, "sslHandler", (ChannelHandler)sslHandler);
        ctx.pipeline().addAfter("sslHandler", "sslHandshakeTimingHandler", (ChannelHandler)new SslHandshakeTimingHandler((Future<Channel>)sslHandler.handshakeFuture()));
        ctx.pipeline().addAfter("sslHandler", "CertificateHandler", (ChannelHandler)new CertificateHandler(sslHandler));
        ctx.pipeline().remove(PIPELINE_SESSION_RESUMPTION_HANDLER);
        super.connect(ctx, remoteAddress, localAddress, promise);
    }

    @FunctionalInterface
    static interface SslHandlerGenerator {
        public SslHandler create(ChannelHandlerContext var1, String var2, int var3);
    }
}

