/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.netty.handler.common;

import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.message.timing.TimingContextUtil;
import com.linkedin.r2.message.timing.TimingImportance;
import com.linkedin.r2.message.timing.TimingKey;
import com.linkedin.r2.transport.common.bridge.common.TransportCallback;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.Future;

public class SslHandshakeTimingHandler
extends ChannelOutboundHandlerAdapter {
    public static final String SSL_HANDSHAKE_TIMING_HANDLER = "sslHandshakeTimingHandler";
    public static final AttributeKey<Long> SSL_HANDSHAKE_START_TIME = AttributeKey.valueOf((String)"sslHandshakeStartTime");
    public static final TimingKey TIMING_KEY = TimingKey.registerNewKey((String)"ssl_handshake", (TimingImportance)TimingImportance.LOW);
    private final Future<Channel> _handshakeFuture;

    public SslHandshakeTimingHandler(Future<Channel> handshakeFuture) {
        this._handshakeFuture = handshakeFuture;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        long startTime = System.nanoTime();
        this._handshakeFuture.addListener(future -> {
            if (future.isSuccess()) {
                long duration = System.nanoTime() - startTime;
                ctx.channel().attr(SSL_HANDSHAKE_START_TIME).set((Object)duration);
            }
        });
    }

    public static <T> TransportCallback<T> getSslTimingCallback(Channel channel, RequestContext requestContext, TransportCallback<T> callback) {
        return response -> {
            Long duration = (Long)channel.attr(SSL_HANDSHAKE_START_TIME).getAndSet(null);
            if (duration != null) {
                TimingContextUtil.markTiming((RequestContext)requestContext, (TimingKey)TIMING_KEY, (long)duration);
            }
            callback.onResponse(response);
        };
    }
}

