/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.netty.handler.http;

import com.linkedin.data.ByteString;
import com.linkedin.r2.message.stream.StreamResponseBuilder;
import com.linkedin.r2.netty.entitystream.StreamWriter;
import io.netty.buffer.ByteBufInputStream;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

public class HttpMessageDecoders {
    public static ResponseDecoder newResponseDecoder() {
        return new ResponseDecoder();
    }

    public static DataDecoder newDataDecoder() {
        return new DataDecoder();
    }

    @ChannelHandler.Sharable
    public static class DataDecoder
    extends MessageToMessageDecoder<HttpContent> {
        private DataDecoder() {
        }

        protected void decode(ChannelHandlerContext ctx, HttpContent chunk, List<Object> out) throws Exception {
            if (!chunk.decoderResult().isSuccess()) {
                ctx.fireExceptionCaught(chunk.decoderResult().cause());
            }
            if (chunk.content().isReadable()) {
                out.add(ByteString.read((InputStream)new ByteBufInputStream(chunk.content()), (int)chunk.content().readableBytes()));
            }
            if (chunk instanceof LastHttpContent) {
                out.add(StreamWriter.EOF);
            }
        }
    }

    @ChannelHandler.Sharable
    public static class ResponseDecoder
    extends MessageToMessageDecoder<HttpResponse> {
        private ResponseDecoder() {
        }

        protected void decode(ChannelHandlerContext ctx, HttpResponse response, List<Object> out) {
            if (!response.decoderResult().isSuccess()) {
                ctx.fireExceptionCaught(response.decoderResult().cause());
                return;
            }
            if (HttpUtil.isTransferEncodingChunked((HttpMessage)response)) {
                HttpUtil.setTransferEncodingChunked((HttpMessage)response, (boolean)false);
            }
            out.add(ResponseDecoder.buildStreamResponse(response));
        }

        public static StreamResponseBuilder buildStreamResponse(HttpResponse response) {
            StreamResponseBuilder builder = new StreamResponseBuilder();
            builder.setStatus(response.status().code());
            for (Map.Entry entry : response.headers()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (key.equalsIgnoreCase("Set-Cookie")) {
                    builder.addCookie(value);
                    continue;
                }
                builder.unsafeAddHeaderValue(key, value);
            }
            return builder;
        }
    }
}

