/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.netty.handler.http;

import com.linkedin.data.ByteString;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.stream.StreamRequest;
import com.linkedin.r2.netty.common.NettyRequestAdapter;
import com.linkedin.r2.netty.entitystream.StreamReader;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.LastHttpContent;
import java.nio.ByteBuffer;
import java.util.List;

public class HttpMessageEncoders {
    public static StreamRequestEncoder newStreamRequestEncoder() {
        return new StreamRequestEncoder();
    }

    public static RestRequestEncoder newRestRequestEncoder() {
        return new RestRequestEncoder();
    }

    public static DataEncoder newDataEncoder() {
        return new DataEncoder();
    }

    public static class DataEncoder
    extends MessageToMessageEncoder<ByteString> {
        private DataEncoder() {
        }

        protected void encode(ChannelHandlerContext ctx, ByteString data, List<Object> out) {
            if (StreamReader.EOF == data) {
                out.add(LastHttpContent.EMPTY_LAST_CONTENT);
            } else {
                out.add(new DefaultHttpContent(Unpooled.wrappedBuffer((ByteBuffer)data.asByteBuffer())));
            }
        }
    }

    public static class RestRequestEncoder
    extends MessageToMessageEncoder<RestRequest> {
        private RestRequestEncoder() {
        }

        protected void encode(ChannelHandlerContext ctx, RestRequest request, List<Object> out) throws Exception {
            out.add(NettyRequestAdapter.toNettyRequest(request));
        }
    }

    public static class StreamRequestEncoder
    extends MessageToMessageEncoder<StreamRequest> {
        private StreamRequestEncoder() {
        }

        protected void encode(ChannelHandlerContext ctx, StreamRequest request, List<Object> out) throws Exception {
            out.add(NettyRequestAdapter.toNettyRequest(request));
        }
    }
}

