/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.netty.handler.http2;

import com.linkedin.r2.netty.handler.http2.UnsupportedHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.Http2FrameCodecBuilder;
import io.netty.handler.codec.http2.Http2MultiplexHandler;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import java.nio.channels.ClosedChannelException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Http2AlpnHandler
extends ApplicationProtocolNegotiationHandler {
    private static Logger LOG = LoggerFactory.getLogger(Http2AlpnHandler.class);
    private final ChannelPromise _alpnPromise;
    private final Http2Settings _http2Settings;

    public Http2AlpnHandler(ChannelPromise alpnPromise, Http2Settings http2Settings) {
        super("http/1.1");
        this._alpnPromise = alpnPromise;
        this._http2Settings = http2Settings;
    }

    protected void configurePipeline(ChannelHandlerContext ctx, String protocol) {
        switch (protocol) {
            case "h2": {
                ctx.pipeline().addLast(new ChannelHandler[]{Http2FrameCodecBuilder.forClient().initialSettings(this._http2Settings).build()});
                ctx.pipeline().addLast(new ChannelHandler[]{new Http2MultiplexHandler((ChannelHandler)new UnsupportedHandler())});
                this._alpnPromise.setSuccess();
                break;
            }
            default: {
                this._alpnPromise.setFailure((Throwable)new IllegalStateException("Unsupported protocol '" + protocol + "' is negotiated."));
            }
        }
    }

    protected void handshakeFailure(ChannelHandlerContext ctx, Throwable cause) {
        this.trySetAlpnFailure(cause);
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        LOG.error("******** Http2AlpnHandler inactive " + ctx.channel() + " ********");
        this.trySetAlpnFailure(new ClosedChannelException());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.trySetAlpnFailure(cause);
    }

    private void trySetAlpnFailure(Throwable cause) {
        if (!this._alpnPromise.isDone()) {
            this._alpnPromise.setFailure((Throwable)new IllegalStateException("HTTP/2 ALPN failed", cause));
        }
    }
}

