/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.netty.handler.http2;

import com.linkedin.data.ByteString;
import com.linkedin.r2.message.stream.StreamResponseBuilder;
import com.linkedin.r2.netty.entitystream.StreamWriter;
import io.netty.buffer.ByteBufInputStream;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

public class Http2MessageDecoders {
    public static ResponseDecoder newResponseDecoder() {
        return new ResponseDecoder();
    }

    public static DataDecoder newDataDecoder() {
        return new DataDecoder();
    }

    @ChannelHandler.Sharable
    public static class DataDecoder
    extends MessageToMessageDecoder<Http2DataFrame> {
        private DataDecoder() {
        }

        protected void decode(ChannelHandlerContext ctx, Http2DataFrame frame, List<Object> out) throws Exception {
            if (frame.content().isReadable()) {
                out.add(ByteString.read((InputStream)new ByteBufInputStream(frame.content()), (int)frame.content().readableBytes()));
            }
            if (frame.isEndStream()) {
                out.add(StreamWriter.EOF);
            }
        }
    }

    @ChannelHandler.Sharable
    public static class ResponseDecoder
    extends MessageToMessageDecoder<Http2HeadersFrame> {
        private ResponseDecoder() {
        }

        protected void decode(ChannelHandlerContext ctx, Http2HeadersFrame frame, List<Object> out) {
            Http2Headers headers = frame.headers();
            StreamResponseBuilder builder = ResponseDecoder.buildStreamResponse(headers);
            out.add(builder);
            if (frame.isEndStream()) {
                out.add(StreamWriter.EOF);
            }
        }

        public static StreamResponseBuilder buildStreamResponse(Http2Headers headers) {
            StreamResponseBuilder builder = new StreamResponseBuilder();
            ResponseDecoder.processPsuedoHttp2Headers(builder, headers);
            ResponseDecoder.processOtherHttp2HeadersAndCookies(builder, headers);
            return builder;
        }

        private static void processOtherHttp2HeadersAndCookies(StreamResponseBuilder builder, Http2Headers headers) {
            for (Map.Entry header : headers) {
                if (Http2Headers.PseudoHeaderName.isPseudoHeader((CharSequence)((CharSequence)header.getKey()))) continue;
                String key = ((CharSequence)header.getKey()).toString();
                String value = ((CharSequence)header.getValue()).toString();
                if (key.equalsIgnoreCase("Set-Cookie")) {
                    builder.addCookie(value);
                    continue;
                }
                builder.unsafeAddHeaderValue(key, value);
            }
        }

        private static void processPsuedoHttp2Headers(StreamResponseBuilder builder, Http2Headers headers) {
            if (headers.status() != null) {
                builder.setStatus(Integer.parseInt(headers.status().toString()));
            }
            if (headers.authority() != null) {
                builder.addHeaderValue(HttpHeaderNames.HOST.toString(), headers.authority().toString());
            }
        }
    }
}

