/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.netty.handler.http2;

import com.linkedin.data.ByteString;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.stream.StreamRequest;
import com.linkedin.r2.netty.common.NettyRequestAdapter;
import com.linkedin.r2.netty.entitystream.StreamReader;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import io.netty.handler.codec.http2.DefaultHttp2HeadersFrame;
import java.nio.ByteBuffer;
import java.util.List;

public final class Http2MessageEncoders {
    private static final boolean END_OF_STREAM = true;

    public static StreamRequestEncoder newStreamRequestEncoder() {
        return new StreamRequestEncoder();
    }

    public static RestRequestEncoder newRestRequestEncoder() {
        return new RestRequestEncoder();
    }

    public static DataEncoder newDataEncoder() {
        return new DataEncoder();
    }

    public static class DataEncoder
    extends MessageToMessageEncoder<ByteString> {
        private DataEncoder() {
        }

        protected void encode(ChannelHandlerContext ctx, ByteString data, List<Object> out) {
            if (StreamReader.EOF == data) {
                out.add(new DefaultHttp2DataFrame(Unpooled.EMPTY_BUFFER, true));
            } else {
                out.add(new DefaultHttp2DataFrame(Unpooled.wrappedBuffer((ByteBuffer)data.asByteBuffer())));
            }
        }
    }

    public static class RestRequestEncoder
    extends MessageToMessageEncoder<RestRequest> {
        private RestRequestEncoder() {
        }

        protected void encode(ChannelHandlerContext ctx, RestRequest request, List<Object> out) throws Exception {
            out.add(new DefaultHttp2HeadersFrame(NettyRequestAdapter.toHttp2Headers(request)));
            ByteBuf content = Unpooled.wrappedBuffer((ByteBuffer)request.getEntity().asByteBuffer());
            out.add(new DefaultHttp2DataFrame(content, true));
        }
    }

    public static class StreamRequestEncoder
    extends MessageToMessageEncoder<StreamRequest> {
        private StreamRequestEncoder() {
        }

        protected void encode(ChannelHandlerContext ctx, StreamRequest request, List<Object> out) throws Exception {
            out.add(new DefaultHttp2HeadersFrame(NettyRequestAdapter.toHttp2Headers(request)));
        }
    }
}

