/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.netty.handler.http2;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpClientUpgradeHandler;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import java.net.InetSocketAddress;
import java.nio.channels.ClosedChannelException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Http2ProtocolUpgradeHandler
extends ChannelDuplexHandler {
    private static final Logger LOG = LoggerFactory.getLogger(Http2ProtocolUpgradeHandler.class);
    private ChannelPromise _upgradePromise;

    public Http2ProtocolUpgradeHandler(ChannelPromise upgradePromise) {
        this._upgradePromise = upgradePromise;
    }

    private void configurePipeline(ChannelHandlerContext ctx, HttpClientUpgradeHandler.UpgradeEvent event) {
        if (event == HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_SUCCESSFUL) {
            ctx.pipeline().remove((ChannelHandler)this);
            this._upgradePromise.setSuccess();
        } else if (event == HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_REJECTED) {
            this._upgradePromise.setFailure((Throwable)new IllegalStateException("HTTP/2 clear text upgrade failed"));
        }
    }

    public void channelActive(ChannelHandlerContext ctx) {
        Http2ProtocolUpgradeHandler.processChannelActive(ctx, LOG, this._upgradePromise);
    }

    public static void processChannelActive(ChannelHandlerContext ctx, Logger log, ChannelPromise upgradePromise) {
        String hostname;
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.OPTIONS, "*");
        if (ctx.channel().remoteAddress() instanceof InetSocketAddress) {
            InetSocketAddress inetAddress = (InetSocketAddress)ctx.channel().remoteAddress();
            hostname = inetAddress.getHostString() + ":" + inetAddress.getPort();
        } else {
            hostname = "localhost";
            log.warn("The remoteAddress is not an InetSocketAddress, therefore it has been used '" + hostname + "' for the HOST of the upgrade request", (Object)ctx.channel().remoteAddress());
        }
        request.headers().add((CharSequence)HttpHeaderNames.HOST, (Object)hostname);
        ctx.writeAndFlush((Object)request);
        ctx.channel().closeFuture().addListener(future -> {
            if (!upgradePromise.isDone()) {
                upgradePromise.setFailure((Throwable)new ChannelException("HTTP/2 upgrade did not complete before channel closed"));
            }
        });
        ctx.fireChannelActive();
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (evt instanceof HttpClientUpgradeHandler.UpgradeEvent) {
            this.configurePipeline(ctx, (HttpClientUpgradeHandler.UpgradeEvent)evt);
        }
        ctx.fireUserEventTriggered(evt);
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        this.trySetUpgradeFailure(new ClosedChannelException());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.trySetUpgradeFailure(cause);
    }

    private void trySetUpgradeFailure(Throwable cause) {
        if (!this._upgradePromise.isDone()) {
            this._upgradePromise.setFailure((Throwable)new IllegalStateException("HTTP/2 clear text upgrade failed", cause));
        }
    }
}

