/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.client;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.callback.MultiCallback;
import com.linkedin.common.util.None;
import com.linkedin.r2.disruptor.DisruptFilter;
import com.linkedin.r2.event.EventProviderRegistry;
import com.linkedin.r2.filter.CompressionConfig;
import com.linkedin.r2.filter.FilterChain;
import com.linkedin.r2.filter.FilterChains;
import com.linkedin.r2.filter.TimedRestFilter;
import com.linkedin.r2.filter.TimedStreamFilter;
import com.linkedin.r2.filter.compression.ClientCompressionFilter;
import com.linkedin.r2.filter.compression.ClientStreamCompressionFilter;
import com.linkedin.r2.filter.compression.EncodingType;
import com.linkedin.r2.filter.compression.streaming.StreamEncodingType;
import com.linkedin.r2.filter.message.rest.RestFilter;
import com.linkedin.r2.filter.message.stream.StreamFilter;
import com.linkedin.r2.filter.transport.ClientQueryTunnelFilter;
import com.linkedin.r2.filter.transport.FilterChainClient;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.message.stream.StreamRequest;
import com.linkedin.r2.message.stream.StreamResponse;
import com.linkedin.r2.transport.common.TransportClientFactory;
import com.linkedin.r2.transport.common.bridge.client.TransportClient;
import com.linkedin.r2.transport.common.bridge.common.TransportCallback;
import com.linkedin.r2.transport.http.client.AbstractJmxManager;
import com.linkedin.r2.transport.http.client.AsyncPoolImpl;
import com.linkedin.r2.transport.http.client.common.ChannelPoolManager;
import com.linkedin.r2.transport.http.client.common.ChannelPoolManagerFactory;
import com.linkedin.r2.transport.http.client.common.ChannelPoolManagerFactoryImpl;
import com.linkedin.r2.transport.http.client.common.ChannelPoolManagerKey;
import com.linkedin.r2.transport.http.client.common.ChannelPoolManagerKeyBuilder;
import com.linkedin.r2.transport.http.client.common.ConnectionSharingChannelPoolManagerFactory;
import com.linkedin.r2.transport.http.client.common.EventAwareChannelPoolManagerFactory;
import com.linkedin.r2.transport.http.client.rest.HttpNettyClient;
import com.linkedin.r2.transport.http.client.stream.AbstractNettyStreamClient;
import com.linkedin.r2.transport.http.client.stream.http.HttpNettyStreamClient;
import com.linkedin.r2.transport.http.client.stream.http2.Http2NettyStreamClient;
import com.linkedin.r2.transport.http.common.HttpProtocolVersion;
import com.linkedin.r2.util.ConfigValueExtractor;
import com.linkedin.r2.util.NamedThreadFactory;
import com.linkedin.util.clock.Clock;
import com.linkedin.util.clock.SystemClock;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientFactory
implements TransportClientFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HttpClientFactory.class);
    public static final String HTTP_QUERY_POST_THRESHOLD = "http.queryPostThreshold";
    public static final String HTTP_REQUEST_TIMEOUT = "http.requestTimeout";
    public static final String HTTP_STREAMING_TIMEOUT = "http.streamingTimeout";
    public static final String HTTP_MAX_RESPONSE_SIZE = "http.maxResponseSize";
    public static final String HTTP_POOL_SIZE = "http.poolSize";
    public static final String HTTP_POOL_WAITER_SIZE = "http.poolWaiterSize";
    public static final String HTTP_IDLE_TIMEOUT = "http.idleTimeout";
    public static final String HTTP_SSL_IDLE_TIMEOUT = "http.sslIdleTimeout";
    public static final String HTTP_SHUTDOWN_TIMEOUT = "http.shutdownTimeout";
    public static final String HTTP_GRACEFUL_SHUTDOWN_TIMEOUT = "http.gracefulShutdownTimeout";
    public static final String HTTP_SSL_CONTEXT = "http.sslContext";
    public static final String HTTP_SSL_PARAMS = "http.sslParams";
    public static final String HTTP_RESPONSE_COMPRESSION_OPERATIONS = "http.responseCompressionOperations";
    public static final String HTTP_RESPONSE_CONTENT_ENCODINGS = "http.responseContentEncodings";
    public static final String HTTP_REQUEST_CONTENT_ENCODINGS = "http.requestContentEncodings";
    public static final String HTTP_USE_RESPONSE_COMPRESSION = "http.useResponseCompression";
    public static final String HTTP_SERVICE_NAME = "http.serviceName";
    public static final String HTTP_POOL_STATS_NAME_PREFIX = "http.poolStatsNamePrefix";
    public static final String HTTP_POOL_STRATEGY = "http.poolStrategy";
    public static final String HTTP_POOL_MIN_SIZE = "http.poolMinSize";
    public static final String HTTP_MAX_HEADER_SIZE = "http.maxHeaderSize";
    public static final String HTTP_MAX_CHUNK_SIZE = "http.maxChunkSize";
    public static final String HTTP_MAX_CONCURRENT_CONNECTIONS = "http.maxConcurrentConnections";
    public static final String HTTP_TCP_NO_DELAY = "http.tcpNoDelay";
    public static final String HTTP_PROTOCOL_VERSION = "http.protocolVersion";
    public static final String HTTP_MAX_CLIENT_REQUEST_RETRY_RATIO = "http.maxClientRequestRetryRatio";
    public static final int DEFAULT_QUERY_POST_THRESHOLD = Integer.MAX_VALUE;
    public static final int DEFAULT_POOL_WAITER_SIZE = Integer.MAX_VALUE;
    public static final int DEFAULT_POOL_SIZE = 200;
    public static final int DEFAULT_REQUEST_TIMEOUT = 1000;
    public static final int DEFAULT_STREAMING_TIMEOUT = -1;
    public static final int DEFAULT_MINIMUM_STREAMING_TIMEOUT = 1000;
    public static final int DEFAULT_GRACEFUL_SHUTDOWN_TIMEOUT = 30000;
    public static final long DEFAULT_IDLE_TIMEOUT = 25000L;
    public static final long DEFAULT_SSL_IDLE_TIMEOUT = 10500000L;
    public static final int DEFAULT_SHUTDOWN_TIMEOUT = 15000;
    public static final long DEFAULT_MAX_RESPONSE_SIZE = 0x200000L;
    public static final String DEFAULT_CLIENT_NAME = "noNameSpecifiedClient";
    public static final String DEFAULT_POOL_STATS_NAME_PREFIX = "noSpecifiedNamePrefix";
    public static final AsyncPoolImpl.Strategy DEFAULT_POOL_STRATEGY = AsyncPoolImpl.Strategy.MRU;
    public static final int DEFAULT_POOL_MIN_SIZE = 0;
    public static final int DEFAULT_MAX_HEADER_SIZE = 8192;
    public static final int DEFAULT_MAX_CHUNK_SIZE = 8192;
    public static final int DEFAULT_CONNECT_TIMEOUT = 30000;
    public static final int DEFAULT_SSL_HANDSHAKE_TIMEOUT = 10000;
    public static final int DEFAULT_CHANNELPOOL_WAITER_TIMEOUT = Integer.MAX_VALUE;
    public static final double DEFAULT_MAX_CLIENT_REQUEST_RETRY_RATIO = 0.2;
    public static final double UNLIMITED_CLIENT_REQUEST_RETRY_RATIO = 1.0;
    public static final int PIPELINE_V2_MATURITY_LEVEL = 1;
    public static final boolean DEFAULT_TCP_NO_DELAY = true;
    public static final boolean DEFAULT_SHARE_CONNECTION = false;
    public static final int DEFAULT_MAX_CONCURRENT_CONNECTIONS = Integer.MAX_VALUE;
    public static final EncodingType[] DEFAULT_RESPONSE_CONTENT_ENCODINGS = new EncodingType[]{EncodingType.GZIP, EncodingType.SNAPPY, EncodingType.SNAPPY_FRAMED, EncodingType.DEFLATE, EncodingType.BZIP2};
    public static final StreamEncodingType[] DEFAULT_STREAM_RESPONSE_CONTENT_ENCODINGS = new StreamEncodingType[]{StreamEncodingType.GZIP, StreamEncodingType.SNAPPY_FRAMED, StreamEncodingType.DEFLATE, StreamEncodingType.BZIP2};
    private static final String LIST_SEPARATOR = ",";
    private final EventLoopGroup _eventLoopGroup;
    private final ScheduledExecutorService _executor;
    private final ExecutorService _callbackExecutorGroup;
    private final boolean _shutdownFactory;
    private final boolean _shutdownExecutor;
    private final boolean _shutdownCallbackExecutor;
    private final boolean _usePipelineV2;
    private final FilterChain _filters;
    private final Executor _compressionExecutor;
    private final AtomicBoolean _finishingShutdown = new AtomicBoolean(false);
    private volatile ScheduledFuture<?> _shutdownTimeoutTask;
    private final AbstractJmxManager _jmxManager;
    private final CompressionConfig _defaultRequestCompressionConfig;
    private final List<ExecutorService> _executorsToShutDown;
    private final int _connectTimeout;
    private final int _sslHandShakeTimeout;
    private final int _channelPoolWaiterTimeout;
    private final Map<String, CompressionConfig> _requestCompressionConfigs;
    private final Map<String, CompressionConfig> _responseCompressionConfigs;
    private final boolean _useClientCompression;
    private final HttpProtocolVersion _defaultHttpVersion;
    private final Object _mutex = new Object();
    private boolean _running = true;
    private int _clientsOutstanding = 0;
    private Callback<None> _factoryShutdownCallback;
    private ChannelPoolManagerFactory _channelPoolManagerFactory;

    @Deprecated
    public HttpClientFactory() {
        this(FilterChains.empty());
    }

    @Deprecated
    public HttpClientFactory(ExecutorService callbackExecutor, boolean shutdownCallbackExecutor) {
        this(FilterChains.empty(), (EventLoopGroup)new NioEventLoopGroup(0, (ThreadFactory)new NamedThreadFactory("R2 Nio Event Loop")), true, Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("R2 Netty Scheduler")), true, callbackExecutor, shutdownCallbackExecutor);
    }

    @Deprecated
    public HttpClientFactory(FilterChain filters) {
        this(filters, (EventLoopGroup)new NioEventLoopGroup(0, (ThreadFactory)new NamedThreadFactory("R2 Nio Event Loop")), true, Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("R2 Netty Scheduler")), true);
    }

    @Deprecated
    public HttpClientFactory(FilterChain filters, EventLoopGroup eventLoopGroup, boolean shutdownFactory, ScheduledExecutorService executor, boolean shutdownExecutor) {
        this(filters, eventLoopGroup, shutdownFactory, executor, shutdownExecutor, null, false);
    }

    @Deprecated
    public HttpClientFactory(FilterChain filters, EventLoopGroup eventLoopGroup, boolean shutdownFactory, ScheduledExecutorService executor, boolean shutdownExecutor, ExecutorService callbackExecutorGroup, boolean shutdownCallbackExecutor) {
        this(filters, eventLoopGroup, shutdownFactory, executor, shutdownExecutor, callbackExecutorGroup, shutdownCallbackExecutor, AbstractJmxManager.NULL_JMX_MANAGER);
    }

    @Deprecated
    public HttpClientFactory(FilterChain filters, EventLoopGroup eventLoopGroup, boolean shutdownFactory, ScheduledExecutorService executor, boolean shutdownExecutor, ExecutorService callbackExecutorGroup, boolean shutdownCallbackExecutor, AbstractJmxManager jmxManager) {
        this(filters, eventLoopGroup, shutdownFactory, executor, shutdownExecutor, callbackExecutorGroup, shutdownCallbackExecutor, jmxManager, true);
    }

    @Deprecated
    public HttpClientFactory(FilterChain filters, EventLoopGroup eventLoopGroup, boolean shutdownFactory, ScheduledExecutorService executor, boolean shutdownExecutor, ExecutorService callbackExecutorGroup, boolean shutdownCallbackExecutor, AbstractJmxManager jmxManager, int requestCompressionThresholdDefault, Map<String, CompressionConfig> requestCompressionConfigs) {
        this(filters, eventLoopGroup, shutdownFactory, executor, shutdownExecutor, callbackExecutorGroup, shutdownCallbackExecutor, jmxManager, requestCompressionThresholdDefault, requestCompressionConfigs, true);
    }

    @Deprecated
    public HttpClientFactory(FilterChain filters, EventLoopGroup eventLoopGroup, boolean shutdownFactory, ScheduledExecutorService executor, boolean shutdownExecutor, ExecutorService callbackExecutorGroup, boolean shutdownCallbackExecutor, AbstractJmxManager jmxManager, int requestCompressionThresholdDefault, Map<String, CompressionConfig> requestCompressionConfigs, boolean useClientCompression) {
        this(filters, eventLoopGroup, shutdownFactory, executor, shutdownExecutor, callbackExecutorGroup, shutdownCallbackExecutor, jmxManager, requestCompressionThresholdDefault, requestCompressionConfigs, Collections.emptyMap(), useClientCompression);
    }

    @Deprecated
    public HttpClientFactory(FilterChain filters, EventLoopGroup eventLoopGroup, boolean shutdownFactory, ScheduledExecutorService executor, boolean shutdownExecutor, ExecutorService callbackExecutorGroup, boolean shutdownCallbackExecutor, AbstractJmxManager jmxManager, int requestCompressionThresholdDefault, Map<String, CompressionConfig> requestCompressionConfigs, Map<String, CompressionConfig> responseCompressionConfigs, boolean useClientCompression) {
        this(filters, eventLoopGroup, shutdownFactory, executor, shutdownExecutor, callbackExecutorGroup, shutdownCallbackExecutor, jmxManager, requestCompressionThresholdDefault, requestCompressionConfigs, responseCompressionConfigs, true, useClientCompression ? Executors.newCachedThreadPool() : null, HttpProtocolVersion.HTTP_1_1);
    }

    @Deprecated
    public HttpClientFactory(FilterChain filters, EventLoopGroup eventLoopGroup, boolean shutdownFactory, ScheduledExecutorService executor, boolean shutdownExecutor, ExecutorService callbackExecutorGroup, boolean shutdownCallbackExecutor, AbstractJmxManager jmxManager, boolean deprecatedTcpNoDelay) {
        this(filters, eventLoopGroup, shutdownFactory, executor, shutdownExecutor, callbackExecutorGroup, shutdownCallbackExecutor, jmxManager, deprecatedTcpNoDelay, Integer.MAX_VALUE, Collections.emptyMap(), Executors.newCachedThreadPool());
    }

    @Deprecated
    public HttpClientFactory(FilterChain filters, EventLoopGroup eventLoopGroup, boolean shutdownFactory, ScheduledExecutorService executor, boolean shutdownExecutor, ExecutorService callbackExecutorGroup, boolean shutdownCallbackExecutor, AbstractJmxManager jmxManager, boolean deprecatedTcpNoDelay, int requestCompressionThresholdDefault, Map<String, CompressionConfig> requestCompressionConfigs, Executor compressionExecutor) {
        this(filters, eventLoopGroup, shutdownFactory, executor, shutdownExecutor, callbackExecutorGroup, shutdownCallbackExecutor, jmxManager, requestCompressionThresholdDefault, requestCompressionConfigs, Collections.emptyMap(), deprecatedTcpNoDelay, compressionExecutor, HttpProtocolVersion.HTTP_1_1);
    }

    @Deprecated
    public HttpClientFactory(FilterChain filters, EventLoopGroup eventLoopGroup, boolean shutdownFactory, ScheduledExecutorService executor, boolean shutdownExecutor, ExecutorService callbackExecutorGroup, boolean shutdownCallbackExecutor, AbstractJmxManager jmxManager, int requestCompressionThresholdDefault, Map<String, CompressionConfig> requestCompressionConfigs, Map<String, CompressionConfig> responseCompressionConfigs, boolean deprecatedTcpNoDelay, Executor compressionExecutor) {
        this(filters, eventLoopGroup, shutdownFactory, executor, shutdownExecutor, callbackExecutorGroup, shutdownCallbackExecutor, jmxManager, requestCompressionThresholdDefault, requestCompressionConfigs, responseCompressionConfigs, deprecatedTcpNoDelay, compressionExecutor, HttpProtocolVersion.HTTP_1_1);
    }

    @Deprecated
    public HttpClientFactory(FilterChain filters, EventLoopGroup eventLoopGroup, boolean shutdownFactory, ScheduledExecutorService executor, boolean shutdownExecutor, ExecutorService callbackExecutorGroup, boolean shutdownCallbackExecutor, AbstractJmxManager jmxManager, int requestCompressionThresholdDefault, Map<String, CompressionConfig> requestCompressionConfigs, Map<String, CompressionConfig> responseCompressionConfigs, boolean deprecatedTcpNoDelay, Executor compressionExecutor, HttpProtocolVersion defaultHttpVersion) {
        this(filters, eventLoopGroup, shutdownFactory, executor, shutdownExecutor, callbackExecutorGroup, shutdownCallbackExecutor, jmxManager, requestCompressionThresholdDefault, requestCompressionConfigs, responseCompressionConfigs, compressionExecutor, defaultHttpVersion);
    }

    @Deprecated
    public HttpClientFactory(FilterChain filters, EventLoopGroup eventLoopGroup, boolean shutdownFactory, ScheduledExecutorService executor, boolean shutdownExecutor, ExecutorService callbackExecutorGroup, boolean shutdownCallbackExecutor, AbstractJmxManager jmxManager, int requestCompressionThresholdDefault, Map<String, CompressionConfig> requestCompressionConfigs, Map<String, CompressionConfig> responseCompressionConfigs, Executor compressionExecutor, HttpProtocolVersion defaultHttpVersion) {
        this(filters, eventLoopGroup, shutdownFactory, executor, shutdownExecutor, callbackExecutorGroup, shutdownCallbackExecutor, jmxManager, requestCompressionThresholdDefault, requestCompressionConfigs, responseCompressionConfigs, compressionExecutor, defaultHttpVersion, false);
    }

    @Deprecated
    public HttpClientFactory(FilterChain filters, EventLoopGroup eventLoopGroup, boolean shutdownFactory, ScheduledExecutorService executor, boolean shutdownExecutor, ExecutorService callbackExecutorGroup, boolean shutdownCallbackExecutor, AbstractJmxManager jmxManager, int requestCompressionThresholdDefault, Map<String, CompressionConfig> requestCompressionConfigs, Map<String, CompressionConfig> responseCompressionConfigs, Executor compressionExecutor, HttpProtocolVersion defaultHttpVersion, boolean shareConnection) {
        this(filters, eventLoopGroup, shutdownFactory, executor, shutdownExecutor, callbackExecutorGroup, shutdownCallbackExecutor, jmxManager, requestCompressionThresholdDefault, requestCompressionConfigs, responseCompressionConfigs, compressionExecutor, defaultHttpVersion, shareConnection, new EventProviderRegistry());
    }

    @Deprecated
    public HttpClientFactory(FilterChain filters, EventLoopGroup eventLoopGroup, boolean shutdownFactory, ScheduledExecutorService executor, boolean shutdownExecutor, ExecutorService callbackExecutorGroup, boolean shutdownCallbackExecutor, AbstractJmxManager jmxManager, int requestCompressionThresholdDefault, Map<String, CompressionConfig> requestCompressionConfigs, Map<String, CompressionConfig> responseCompressionConfigs, Executor compressionExecutor, HttpProtocolVersion defaultHttpVersion, boolean shareConnection, EventProviderRegistry eventProviderRegistry) {
        this(filters, eventLoopGroup, shutdownFactory, executor, shutdownExecutor, callbackExecutorGroup, shutdownCallbackExecutor, jmxManager, requestCompressionThresholdDefault, requestCompressionConfigs, responseCompressionConfigs, compressionExecutor, defaultHttpVersion, shareConnection, eventProviderRegistry, true, false);
    }

    private HttpClientFactory(FilterChain filters, EventLoopGroup eventLoopGroup, boolean shutdownFactory, ScheduledExecutorService executor, boolean shutdownExecutor, ExecutorService callbackExecutorGroup, boolean shutdownCallbackExecutor, AbstractJmxManager jmxManager, int requestCompressionThresholdDefault, Map<String, CompressionConfig> requestCompressionConfigs, Map<String, CompressionConfig> responseCompressionConfigs, Executor compressionExecutor, HttpProtocolVersion defaultHttpVersion, boolean shareConnection, EventProviderRegistry eventProviderRegistry, boolean enableSSLSessionResumption, boolean usePipelineV2) {
        this(filters, eventLoopGroup, shutdownFactory, executor, shutdownExecutor, callbackExecutorGroup, shutdownCallbackExecutor, jmxManager, requestCompressionThresholdDefault, requestCompressionConfigs, responseCompressionConfigs, compressionExecutor, defaultHttpVersion, shareConnection, eventProviderRegistry, enableSSLSessionResumption, usePipelineV2, null);
    }

    private HttpClientFactory(FilterChain filters, EventLoopGroup eventLoopGroup, boolean shutdownFactory, ScheduledExecutorService executor, boolean shutdownExecutor, ExecutorService callbackExecutorGroup, boolean shutdownCallbackExecutor, AbstractJmxManager jmxManager, int requestCompressionThresholdDefault, Map<String, CompressionConfig> requestCompressionConfigs, Map<String, CompressionConfig> responseCompressionConfigs, Executor compressionExecutor, HttpProtocolVersion defaultHttpVersion, boolean shareConnection, EventProviderRegistry eventProviderRegistry, boolean enableSSLSessionResumption, boolean usePipelineV2, List<ExecutorService> executorsToShutDown) {
        this(filters, eventLoopGroup, shutdownFactory, executor, shutdownExecutor, callbackExecutorGroup, shutdownCallbackExecutor, jmxManager, requestCompressionThresholdDefault, requestCompressionConfigs, responseCompressionConfigs, compressionExecutor, defaultHttpVersion, shareConnection, eventProviderRegistry, enableSSLSessionResumption, usePipelineV2, executorsToShutDown, 30000, 10000, Integer.MAX_VALUE);
    }

    private HttpClientFactory(FilterChain filters, EventLoopGroup eventLoopGroup, boolean shutdownFactory, ScheduledExecutorService executor, boolean shutdownExecutor, ExecutorService callbackExecutorGroup, boolean shutdownCallbackExecutor, AbstractJmxManager jmxManager, int requestCompressionThresholdDefault, Map<String, CompressionConfig> requestCompressionConfigs, Map<String, CompressionConfig> responseCompressionConfigs, Executor compressionExecutor, HttpProtocolVersion defaultHttpVersion, boolean shareConnection, EventProviderRegistry eventProviderRegistry, boolean enableSSLSessionResumption, boolean usePipelineV2, List<ExecutorService> executorsToShutDown, int connectTimeout, int sslHandShakeTimeout, int channelPoolWaiterTimeout) {
        this._filters = filters;
        this._eventLoopGroup = eventLoopGroup;
        this._shutdownFactory = shutdownFactory;
        this._executor = executor;
        this._shutdownExecutor = shutdownExecutor;
        this._callbackExecutorGroup = callbackExecutorGroup;
        this._shutdownCallbackExecutor = shutdownCallbackExecutor;
        this._usePipelineV2 = usePipelineV2;
        this._jmxManager = jmxManager;
        this._defaultRequestCompressionConfig = new CompressionConfig(requestCompressionThresholdDefault);
        this._executorsToShutDown = executorsToShutDown;
        this._connectTimeout = connectTimeout;
        this._sslHandShakeTimeout = sslHandShakeTimeout;
        this._channelPoolWaiterTimeout = channelPoolWaiterTimeout;
        if (requestCompressionConfigs == null) {
            throw new IllegalArgumentException("requestCompressionConfigs should not be null.");
        }
        this._requestCompressionConfigs = Collections.unmodifiableMap(requestCompressionConfigs);
        if (responseCompressionConfigs == null) {
            throw new IllegalArgumentException("responseCompressionConfigs should not be null.");
        }
        this._responseCompressionConfigs = Collections.unmodifiableMap(responseCompressionConfigs);
        this._compressionExecutor = compressionExecutor;
        this._useClientCompression = this._compressionExecutor != null;
        this._defaultHttpVersion = defaultHttpVersion;
        this._channelPoolManagerFactory = new ChannelPoolManagerFactoryImpl(this._eventLoopGroup, this._executor, enableSSLSessionResumption, this._usePipelineV2, this._channelPoolWaiterTimeout, this._connectTimeout, this._sslHandShakeTimeout);
        if (eventProviderRegistry != null) {
            this._channelPoolManagerFactory = new EventAwareChannelPoolManagerFactory(this._channelPoolManagerFactory, eventProviderRegistry);
        }
        if (shareConnection) {
            this._channelPoolManagerFactory = new ConnectionSharingChannelPoolManagerFactory(this._channelPoolManagerFactory);
        }
        this._filters.getStreamFilters().stream().filter(TimedStreamFilter.class::isInstance).map(TimedStreamFilter.class::cast).forEach(TimedStreamFilter::setShared);
        this._filters.getRestFilters().stream().filter(TimedRestFilter.class::isInstance).map(TimedRestFilter.class::cast).forEach(TimedRestFilter::setShared);
    }

    public TransportClient getClient(Map<String, ? extends Object> properties) {
        properties = new HashMap<String, Object>(properties);
        SSLContext sslContext = HttpClientFactory.coerceAndRemoveFromMap(HTTP_SSL_CONTEXT, properties, SSLContext.class);
        SSLParameters sslParameters = HttpClientFactory.coerceAndRemoveFromMap(HTTP_SSL_PARAMS, properties, SSLParameters.class);
        return this.getClient(properties, sslContext, sslParameters);
    }

    TransportClient getRawClient(Map<String, String> properties) {
        return this.getRawClient(properties, null, null);
    }

    private static <T> T coerceAndRemoveFromMap(String key, Map<String, ?> props, Class<T> valueClass) {
        return HttpClientFactory.coerce(key, props.remove(key), valueClass);
    }

    private static <T> T coerce(String key, Object value, Class<T> valueClass) {
        if (value == null) {
            return null;
        }
        if (!valueClass.isInstance(value)) {
            throw new IllegalArgumentException("Property " + key + " is of type " + value.getClass().getName() + " but must be " + valueClass.getName());
        }
        return valueClass.cast(value);
    }

    CompressionConfig getRestRequestCompressionConfig(String httpServiceName, EncodingType requestContentEncoding) {
        if (this._requestCompressionConfigs.containsKey(httpServiceName)) {
            if (requestContentEncoding == EncodingType.IDENTITY) {
                LOG.warn("No request compression algorithm available but compression config specified for service {}", (Object)httpServiceName);
            }
            return this._requestCompressionConfigs.get(httpServiceName);
        }
        return this._defaultRequestCompressionConfig;
    }

    CompressionConfig getStreamRequestCompressionConfig(String httpServiceName, StreamEncodingType requestContentEncoding) {
        if (this._requestCompressionConfigs.containsKey(httpServiceName)) {
            if (requestContentEncoding == StreamEncodingType.IDENTITY) {
                LOG.warn("No request compression algorithm available but compression config specified for service {}", (Object)httpServiceName);
            }
            return this._requestCompressionConfigs.get(httpServiceName);
        }
        return this._defaultRequestCompressionConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransportClient getClient(Map<String, ? extends Object> properties, SSLContext sslContext, SSLParameters sslParameters) {
        LOG.debug("Getting a client with configuration {} and SSLContext {}", properties, (Object)sslContext);
        TransportClient client = this.getRawClient(properties, sslContext, sslParameters);
        List httpRequestServerSupportedEncodings = ConfigValueExtractor.buildList((Object)properties.remove(HTTP_REQUEST_CONTENT_ENCODINGS), (String)LIST_SEPARATOR);
        List httpResponseCompressionOperations = ConfigValueExtractor.buildList((Object)properties.remove(HTTP_RESPONSE_COMPRESSION_OPERATIONS), (String)LIST_SEPARATOR);
        String useResponseCompressionProperty = (String)properties.get(HTTP_USE_RESPONSE_COMPRESSION);
        if (useResponseCompressionProperty != null && Boolean.parseBoolean(useResponseCompressionProperty)) {
            httpResponseCompressionOperations.add("*");
        }
        FilterChain filters = this._filters;
        if (this._useClientCompression) {
            List responseEncodings = null;
            if (properties.containsKey(HTTP_RESPONSE_CONTENT_ENCODINGS)) {
                responseEncodings = ConfigValueExtractor.buildList((Object)properties.remove(HTTP_RESPONSE_CONTENT_ENCODINGS), (String)LIST_SEPARATOR);
            }
            String httpServiceName = (String)properties.get(HTTP_SERVICE_NAME);
            EncodingType restRequestContentEncoding = HttpClientFactory.getRestRequestContentEncoding(httpRequestServerSupportedEncodings);
            StreamEncodingType streamRequestContentEncoding = HttpClientFactory.getStreamRequestContentEncoding(httpRequestServerSupportedEncodings);
            filters = restRequestContentEncoding != EncodingType.IDENTITY || !httpResponseCompressionOperations.isEmpty() ? filters.addLastRest((RestFilter)new ClientCompressionFilter(restRequestContentEncoding, this.getRestRequestCompressionConfig(httpServiceName, restRequestContentEncoding), this.buildRestAcceptEncodingSchemaNames(responseEncodings), this._responseCompressionConfigs.get(httpServiceName), httpResponseCompressionOperations)) : filters.addLastRest((RestFilter)new ClientCompressionFilter(EncodingType.IDENTITY, this._defaultRequestCompressionConfig, null, null, Collections.emptyList()));
            if (streamRequestContentEncoding != StreamEncodingType.IDENTITY || !httpResponseCompressionOperations.isEmpty()) {
                CompressionConfig compressionConfig = this.getStreamRequestCompressionConfig(httpServiceName, streamRequestContentEncoding);
                filters = filters.addLast((StreamFilter)new ClientStreamCompressionFilter(streamRequestContentEncoding, compressionConfig, this.buildStreamAcceptEncodingSchemas(responseEncodings), this._responseCompressionConfigs.get(httpServiceName), httpResponseCompressionOperations, this._compressionExecutor));
            } else {
                filters = filters.addLast((StreamFilter)new ClientStreamCompressionFilter(StreamEncodingType.IDENTITY, this._defaultRequestCompressionConfig, null, null, Collections.emptyList(), this._compressionExecutor));
            }
        }
        Integer queryPostThreshold = this.chooseNewOverDefault(this.getIntValue(properties, HTTP_QUERY_POST_THRESHOLD), Integer.MAX_VALUE);
        ClientQueryTunnelFilter clientQueryTunnelFilter = new ClientQueryTunnelFilter(queryPostThreshold.intValue());
        filters = filters.addLastRest((RestFilter)clientQueryTunnelFilter);
        filters = filters.addLast((StreamFilter)clientQueryTunnelFilter);
        Integer requestTimeout = this.chooseNewOverDefault(this.getIntValue(properties, HTTP_REQUEST_TIMEOUT), 1000);
        DisruptFilter disruptFilter = new DisruptFilter(this._executor, (ExecutorService)this._eventLoopGroup, requestTimeout.intValue(), (Clock)SystemClock.instance());
        filters = filters.addLastRest((RestFilter)disruptFilter);
        filters = filters.addLast((StreamFilter)disruptFilter);
        client = new FilterChainClient(client, filters);
        client = new FactoryClient(client);
        Object object = this._mutex;
        synchronized (object) {
            if (!this._running) {
                throw new IllegalStateException("Factory is shutting down");
            }
            ++this._clientsOutstanding;
            return client;
        }
    }

    private static StreamEncodingType getStreamRequestContentEncoding(List<String> serverSupportedEncodings) {
        for (String encoding : serverSupportedEncodings) {
            if (!StreamEncodingType.isSupported((String)encoding)) continue;
            return StreamEncodingType.get((String)encoding);
        }
        return StreamEncodingType.IDENTITY;
    }

    private static EncodingType getRestRequestContentEncoding(List<String> serverSupportedEncodings) {
        for (String encoding : serverSupportedEncodings) {
            if (!EncodingType.isSupported((String)encoding)) continue;
            return EncodingType.get((String)encoding);
        }
        return EncodingType.IDENTITY;
    }

    private StreamEncodingType[] buildStreamAcceptEncodingSchemas(List<String> encodings) {
        if (encodings != null) {
            ArrayList<StreamEncodingType> encodingTypes = new ArrayList<StreamEncodingType>();
            for (String encoding : encodings) {
                if (!StreamEncodingType.isSupported((String)encoding)) continue;
                encodingTypes.add(StreamEncodingType.get((String)encoding));
            }
            return encodingTypes.toArray(new StreamEncodingType[encodingTypes.size()]);
        }
        return DEFAULT_STREAM_RESPONSE_CONTENT_ENCODINGS;
    }

    private EncodingType[] buildRestAcceptEncodingSchemaNames(List<String> encodings) {
        if (encodings != null) {
            ArrayList<EncodingType> encodingTypes = new ArrayList<EncodingType>();
            for (String encoding : encodings) {
                if (!EncodingType.isSupported((String)encoding)) continue;
                encodingTypes.add(EncodingType.get((String)encoding));
            }
            return encodingTypes.toArray(new EncodingType[encodingTypes.size()]);
        }
        return DEFAULT_RESPONSE_CONTENT_ENCODINGS;
    }

    private HttpProtocolVersion getHttpProtocolVersion(Map<String, ? extends Object> properties, String propertyKey) {
        if (properties == null) {
            LOG.warn("passed a null raw client properties");
            return null;
        }
        if (properties.containsKey(propertyKey)) {
            return HttpProtocolVersion.valueOf((String)((String)properties.get(propertyKey)));
        }
        return null;
    }

    private Integer getIntValue(Map<String, ? extends Object> properties, String propertyKey) {
        if (properties == null) {
            LOG.warn("passed a null raw client properties");
            return null;
        }
        if (properties.containsKey(propertyKey)) {
            return Integer.parseInt((String)properties.get(propertyKey));
        }
        return null;
    }

    private Long getLongValue(Map<String, ? extends Object> properties, String propertyKey) {
        if (properties == null) {
            LOG.warn("passed a null raw client properties");
            return null;
        }
        if (properties.containsKey(propertyKey)) {
            return Long.parseLong((String)properties.get(propertyKey));
        }
        return null;
    }

    private Boolean getBooleanValue(Map<String, ? extends Object> properties, String propertyKey) {
        if (properties == null) {
            LOG.warn("passed a null raw client properties");
            return null;
        }
        if (properties.containsKey(propertyKey)) {
            return Boolean.parseBoolean((String)properties.get(propertyKey));
        }
        return null;
    }

    private AsyncPoolImpl.Strategy getStrategy(Map<String, ? extends Object> properties) {
        if (properties == null) {
            LOG.warn("passed a null raw client properties");
            return null;
        }
        if (properties.containsKey(HTTP_POOL_STRATEGY)) {
            String strategyString = (String)properties.get(HTTP_POOL_STRATEGY);
            if (strategyString.equalsIgnoreCase("LRU")) {
                return AsyncPoolImpl.Strategy.LRU;
            }
            if (strategyString.equalsIgnoreCase("MRU")) {
                return AsyncPoolImpl.Strategy.MRU;
            }
        }
        return null;
    }

    private ChannelPoolManagerKey createChannelPoolManagerKey(Map<String, ? extends Object> properties, SSLContext sslContext, SSLParameters sslParameters) {
        String poolStatsNamePrefix = this.chooseNewOverDefault((String)properties.get(HTTP_POOL_STATS_NAME_PREFIX), DEFAULT_POOL_STATS_NAME_PREFIX);
        Integer maxPoolSize = this.chooseNewOverDefault(this.getIntValue(properties, HTTP_POOL_SIZE), 200);
        long idleTimeout = this.chooseNewOverDefault(this.getLongValue(properties, HTTP_IDLE_TIMEOUT), 25000L);
        long sslIdleTimeout = this.chooseNewOverDefault(this.getLongValue(properties, HTTP_SSL_IDLE_TIMEOUT), 10500000L);
        long maxResponseSize = this.chooseNewOverDefault(this.getLongValue(properties, HTTP_MAX_RESPONSE_SIZE), 0x200000L);
        Integer poolWaiterSize = this.chooseNewOverDefault(this.getIntValue(properties, HTTP_POOL_WAITER_SIZE), Integer.MAX_VALUE);
        Integer poolMinSize = this.chooseNewOverDefault(this.getIntValue(properties, HTTP_POOL_MIN_SIZE), 0);
        Integer maxHeaderSize = this.chooseNewOverDefault(this.getIntValue(properties, HTTP_MAX_HEADER_SIZE), 8192);
        Integer maxChunkSize = this.chooseNewOverDefault(this.getIntValue(properties, HTTP_MAX_CHUNK_SIZE), 8192);
        Boolean tcpNoDelay = this.chooseNewOverDefault(this.getBooleanValue(properties, HTTP_TCP_NO_DELAY), true);
        Integer maxConcurrentConnectionInitializations = this.chooseNewOverDefault(this.getIntValue(properties, HTTP_MAX_CONCURRENT_CONNECTIONS), Integer.MAX_VALUE);
        AsyncPoolImpl.Strategy strategy = this.chooseNewOverDefault(this.getStrategy(properties), DEFAULT_POOL_STRATEGY);
        Integer gracefulShutdownTimeout = this.chooseNewOverDefault(this.getIntValue(properties, HTTP_GRACEFUL_SHUTDOWN_TIMEOUT), 30000);
        return new ChannelPoolManagerKeyBuilder().setMaxPoolSize(maxPoolSize).setGracefulShutdownTimeout(gracefulShutdownTimeout).setIdleTimeout(idleTimeout).setSslIdleTimeout(sslIdleTimeout).setMaxResponseSize(maxResponseSize).setSSLContext(sslContext).setPoolWaiterSize(poolWaiterSize).setSSLParameters(sslParameters).setStrategy(strategy).setMinPoolSize(poolMinSize).setMaxHeaderSize(maxHeaderSize).setMaxChunkSize(maxChunkSize).setMaxConcurrentConnectionInitializations(maxConcurrentConnectionInitializations).setTcpNoDelay(tcpNoDelay).setPoolStatsNamePrefix(poolStatsNamePrefix).build();
    }

    TransportClient getRawClient(Map<String, ? extends Object> properties, SSLContext sslContext, SSLParameters sslParameters) {
        AbstractNettyStreamClient streamClient;
        ChannelPoolManagerKey key = this.createChannelPoolManagerKey(properties, null, null);
        ChannelPoolManagerKey sslKey = this.createChannelPoolManagerKey(properties, sslContext, sslParameters);
        int shutdownTimeout = this.chooseNewOverDefault(this.getIntValue(properties, HTTP_SHUTDOWN_TIMEOUT), 15000);
        int requestTimeout = this.chooseNewOverDefault(this.getIntValue(properties, HTTP_REQUEST_TIMEOUT), 1000);
        int streamingTimeout = this.chooseNewOverDefault(this.getIntValue(properties, HTTP_STREAMING_TIMEOUT), -1);
        if (streamingTimeout > -1 && streamingTimeout < 1000) {
            streamingTimeout = 1000;
            LOG.warn("Streaming timeout is too small, resetting to the minimum allowed timeout value of {}ms", (Object)1000);
        }
        String httpServiceName = (String)properties.get(HTTP_SERVICE_NAME);
        HttpProtocolVersion httpProtocolVersion = this.chooseNewOverDefault(this.getHttpProtocolVersion(properties, HTTP_PROTOCOL_VERSION), this._defaultHttpVersion);
        LOG.info("The service '{}' has been assigned to the ChannelPoolManager with key '{}', http.protocolVersion={}, usePipelineV2={}, requestTimeout={}ms, streamingTimeout={}ms", new Object[]{httpServiceName, key.getName(), httpProtocolVersion, this._usePipelineV2, requestTimeout, streamingTimeout});
        if (this._usePipelineV2) {
            ChannelPoolManager sslChannelPoolManager;
            ChannelPoolManager channelPoolManager;
            switch (httpProtocolVersion) {
                case HTTP_1_1: {
                    channelPoolManager = this._channelPoolManagerFactory.buildStream(key);
                    sslChannelPoolManager = this._channelPoolManagerFactory.buildStream(sslKey);
                    break;
                }
                case HTTP_2: {
                    channelPoolManager = this._channelPoolManagerFactory.buildHttp2Stream(key);
                    sslChannelPoolManager = this._channelPoolManagerFactory.buildHttp2Stream(sslKey);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized HTTP protocol version " + httpProtocolVersion);
                }
            }
            return new com.linkedin.r2.netty.client.HttpNettyClient(this._eventLoopGroup, this._executor, this._callbackExecutorGroup, channelPoolManager, sslChannelPoolManager, httpProtocolVersion, (Clock)SystemClock.instance(), requestTimeout, streamingTimeout, shutdownTimeout);
        }
        switch (httpProtocolVersion) {
            case HTTP_1_1: {
                streamClient = new HttpNettyStreamClient(this._eventLoopGroup, this._executor, requestTimeout, shutdownTimeout, this._callbackExecutorGroup, this._jmxManager, this._channelPoolManagerFactory.buildStream(key), this._channelPoolManagerFactory.buildStream(sslKey));
                break;
            }
            case HTTP_2: {
                streamClient = new Http2NettyStreamClient(this._eventLoopGroup, this._executor, requestTimeout, shutdownTimeout, this._callbackExecutorGroup, this._jmxManager, this._channelPoolManagerFactory.buildHttp2Stream(key), this._channelPoolManagerFactory.buildHttp2Stream(sslKey));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized HTTP protocol version " + httpProtocolVersion);
            }
        }
        HttpNettyClient legacyClient = new HttpNettyClient(this._eventLoopGroup, this._executor, requestTimeout, shutdownTimeout, this._callbackExecutorGroup, this._jmxManager, this._channelPoolManagerFactory.buildRest(key), this._channelPoolManagerFactory.buildRest(sslKey));
        return new MixedClient(legacyClient, streamClient);
    }

    private <T> T chooseNewOverDefault(T newValue, T defaultValue) {
        if (newValue == null) {
            return defaultValue;
        }
        return newValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(Callback<None> callback) {
        int count;
        Object object = this._mutex;
        synchronized (object) {
            this._running = false;
            count = this._clientsOutstanding;
            this._factoryShutdownCallback = callback;
        }
        if (count == 0) {
            this.finishShutdown();
        } else {
            LOG.info("Awaiting shutdown of {} outstanding clients", (Object)count);
        }
    }

    public void shutdown(Callback<None> callback, long timeout, TimeUnit timeoutUnit) {
        this._shutdownTimeoutTask = this._executor.schedule(new Runnable(){

            @Override
            public void run() {
                LOG.warn("Shutdown timeout exceeded, proceeding with shutdown");
                HttpClientFactory.this.finishShutdown();
            }
        }, timeout, timeoutUnit);
        this.shutdown(callback);
    }

    private void finishShutdown() {
        if (!this._finishingShutdown.compareAndSet(false, true)) {
            return;
        }
        if (this._shutdownTimeoutTask != null) {
            this._shutdownTimeoutTask.cancel(false);
        }
        this._channelPoolManagerFactory.shutdown(new Callback<None>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void finishShutdown() {
                Callback callback;
                if (HttpClientFactory.this._shutdownFactory) {
                    LOG.info("Shutdown Netty Event Loop");
                    HttpClientFactory.this._eventLoopGroup.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
                }
                if (HttpClientFactory.this._shutdownExecutor) {
                    HttpClientFactory.this._executor.shutdown();
                    HttpClientFactory.this._executor.shutdownNow();
                    LOG.info("Scheduler shutdown complete");
                }
                if (HttpClientFactory.this._shutdownCallbackExecutor) {
                    LOG.info("Shutdown callback executor");
                    HttpClientFactory.this._callbackExecutorGroup.shutdown();
                    HttpClientFactory.this._callbackExecutorGroup.shutdownNow();
                }
                if (HttpClientFactory.this._executorsToShutDown != null) {
                    for (ExecutorService executorService : HttpClientFactory.this._executorsToShutDown) {
                        executorService.shutdown();
                    }
                }
                Object object = HttpClientFactory.this._mutex;
                synchronized (object) {
                    callback = HttpClientFactory.this._factoryShutdownCallback;
                }
                LOG.info("Shutdown complete");
                callback.onSuccess((Object)None.none());
            }

            public void onError(Throwable e) {
                LOG.error("Incurred an error in shutting down channelPoolManagerFactory, the shutdown will be completed", e);
                this.finishShutdown();
            }

            public void onSuccess(None result) {
                this.finishShutdown();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clientShutdown() {
        boolean done;
        Object object = this._mutex;
        synchronized (object) {
            --this._clientsOutstanding;
            done = !this._running && this._clientsOutstanding == 0;
        }
        if (done) {
            this.finishShutdown();
        }
    }

    static class MixedClient
    implements TransportClient {
        private final TransportClient _legacyClient;
        private final TransportClient _streamClient;

        MixedClient(TransportClient legacyClient, TransportClient streamClient) {
            this._legacyClient = legacyClient;
            this._streamClient = streamClient;
        }

        public void restRequest(RestRequest request, RequestContext requestContext, Map<String, String> wireAttrs, TransportCallback<RestResponse> callback) {
            this._legacyClient.restRequest(request, requestContext, wireAttrs, callback);
        }

        public void streamRequest(StreamRequest request, RequestContext requestContext, Map<String, String> wireAttrs, TransportCallback<StreamResponse> callback) {
            this._streamClient.streamRequest(request, requestContext, wireAttrs, callback);
        }

        public void shutdown(Callback<None> callback) {
            MultiCallback multiCallback = new MultiCallback(callback, 2);
            this._legacyClient.shutdown((Callback)multiCallback);
            this._streamClient.shutdown((Callback)multiCallback);
        }
    }

    private class FactoryClient
    implements TransportClient {
        private final TransportClient _client;
        private final AtomicBoolean _shutdown = new AtomicBoolean(false);

        private FactoryClient(TransportClient client) {
            this._client = client;
        }

        public void restRequest(RestRequest request, RequestContext requestContext, Map<String, String> wireAttrs, TransportCallback<RestResponse> callback) {
            this._client.restRequest(request, requestContext, wireAttrs, callback);
        }

        public void streamRequest(StreamRequest request, RequestContext requestContext, Map<String, String> wireAttrs, TransportCallback<StreamResponse> callback) {
            this._client.streamRequest(request, requestContext, wireAttrs, callback);
        }

        public void shutdown(final Callback<None> callback) {
            if (this._shutdown.compareAndSet(false, true)) {
                this._client.shutdown((Callback)new Callback<None>(){

                    public void onSuccess(None none) {
                        try {
                            callback.onSuccess((Object)none);
                        }
                        finally {
                            HttpClientFactory.this.clientShutdown();
                        }
                    }

                    public void onError(Throwable e) {
                        try {
                            callback.onError(e);
                        }
                        finally {
                            HttpClientFactory.this.clientShutdown();
                        }
                    }
                });
            } else {
                callback.onError((Throwable)new IllegalStateException("shutdown has already been requested."));
            }
        }
    }

    public static class Builder {
        private EventLoopGroup _eventLoopGroup = null;
        private ScheduledExecutorService _executor = null;
        private ExecutorService _callbackExecutorGroup = null;
        private boolean _shutdownFactory = true;
        private boolean _shutdownExecutor = true;
        private boolean _shutdownCallbackExecutor = false;
        private boolean _shareConnection = false;
        private FilterChain _filters = FilterChains.empty();
        private boolean _useClientCompression = true;
        private boolean _usePipelineV2 = false;
        private int _pipelineV2MinimumMaturityLevel = 1;
        private Executor _customCompressionExecutor = null;
        private AbstractJmxManager _jmxManager = AbstractJmxManager.NULL_JMX_MANAGER;
        private int _requestCompressionThresholdDefault = Integer.MAX_VALUE;
        private Map<String, CompressionConfig> _requestCompressionConfigs = Collections.emptyMap();
        private Map<String, CompressionConfig> _responseCompressionConfigs = Collections.emptyMap();
        private HttpProtocolVersion _defaultHttpVersion = HttpProtocolVersion.HTTP_1_1;
        private EventProviderRegistry _eventProviderRegistry = null;
        private boolean _enableSSLSessionResumption = true;
        private int _connectTimeout = 30000;
        private int _sslHandShakeTimeout = 10000;
        private int _channelPoolWaiterTimeout = Integer.MAX_VALUE;

        public Builder setEventLoopGroup(EventLoopGroup eventLoopGroup) {
            this._eventLoopGroup = eventLoopGroup;
            return this;
        }

        @Deprecated
        public Builder setNioEventLoopGroup(NioEventLoopGroup nioEventLoopGroup) {
            this._eventLoopGroup = nioEventLoopGroup;
            return this;
        }

        public Builder setScheduleExecutorService(ScheduledExecutorService scheduleExecutorService) {
            this._executor = scheduleExecutorService;
            return this;
        }

        public Builder setCallbackExecutor(ExecutorService callbackExecutor) {
            this._callbackExecutorGroup = callbackExecutor;
            return this;
        }

        public Builder setShutDownFactory(boolean shutDownFactory) {
            this._shutdownFactory = shutDownFactory;
            return this;
        }

        public Builder setShutdownScheduledExecutorService(boolean shutdownExecutor) {
            this._shutdownExecutor = shutdownExecutor;
            return this;
        }

        public Builder setShutdownCallbackExecutor(boolean shutdownCallbackExecutor) {
            this._shutdownCallbackExecutor = shutdownCallbackExecutor;
            return this;
        }

        public Builder setFilterChain(FilterChain filterChain) {
            this._filters = filterChain;
            return this;
        }

        public Builder setUseClientCompression(boolean useClientCompression) {
            this._useClientCompression = useClientCompression;
            return this;
        }

        public Builder setShareConnection(boolean shareConnection) {
            this._shareConnection = shareConnection;
            return this;
        }

        public Builder setCompressionExecutor(Executor customCompressionExecutor) {
            this.setUseClientCompression(true);
            this._customCompressionExecutor = customCompressionExecutor;
            return this;
        }

        public Builder setJmxManager(AbstractJmxManager jmxManager) {
            this._jmxManager = jmxManager;
            return this;
        }

        public Builder setRequestCompressionThresholdDefault(int thresholdDefault) {
            this._requestCompressionThresholdDefault = thresholdDefault;
            return this;
        }

        public Builder setRequestCompressionConfigs(Map<String, CompressionConfig> configs) {
            this._requestCompressionConfigs = configs;
            return this;
        }

        public Builder setResponseCompressionConfigs(Map<String, CompressionConfig> configs) {
            this._responseCompressionConfigs = configs;
            return this;
        }

        public Builder setDefaultHttpVersion(HttpProtocolVersion defaultHttpVersion) {
            this._defaultHttpVersion = defaultHttpVersion;
            return this;
        }

        public Builder setEventProviderRegistry(EventProviderRegistry eventProviderRegistry) {
            this._eventProviderRegistry = eventProviderRegistry;
            return this;
        }

        public Builder setSSLSessionResumption(boolean enableSSLSessionResumption) {
            this._enableSSLSessionResumption = enableSSLSessionResumption;
            return this;
        }

        public Builder setConnectTimeout(int connectTimeout) {
            this._connectTimeout = connectTimeout;
            return this;
        }

        public Builder setSslHandShakeTimeout(int sslHandShakeTimeout) {
            this._sslHandShakeTimeout = sslHandShakeTimeout;
            return this;
        }

        public Builder setChannelPoolWaiterTimeout(int channelPoolWaiterTimeout) {
            this._channelPoolWaiterTimeout = channelPoolWaiterTimeout;
            return this;
        }

        public Builder setUsePipelineV2(boolean usePipelineV2) {
            this._usePipelineV2 = usePipelineV2;
            return this;
        }

        public Builder setPipelineV2MinimumMaturityLevel(int pipelineV2MinimumMaturityLevel) {
            this._pipelineV2MinimumMaturityLevel = pipelineV2MinimumMaturityLevel;
            return this;
        }

        public HttpClientFactory build() {
            EventProviderRegistry eventProviderRegistry;
            ExecutorService callbackExecutorGroup;
            ScheduledExecutorService scheduledExecutorService;
            ArrayList<ExecutorService> executorsToShutDown = new ArrayList<ExecutorService>();
            EventLoopGroup eventLoopGroup = this._eventLoopGroup;
            if (eventLoopGroup == null) {
                eventLoopGroup = new NioEventLoopGroup(0, (ThreadFactory)new NamedThreadFactory("R2 Nio Event Loop"));
            }
            if ((scheduledExecutorService = this._executor) == null) {
                LOG.warn("No scheduled executor is provided to HttpClientFactory, using it's own scheduled executor.");
                scheduledExecutorService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("R2 Netty Scheduler"));
                executorsToShutDown.add(scheduledExecutorService);
            }
            if ((callbackExecutorGroup = this._callbackExecutorGroup) == null) {
                LOG.warn("No callback executor is provided to HttpClientFactory, using it's own call back executor.");
                callbackExecutorGroup = Executors.newFixedThreadPool(1);
                executorsToShutDown.add(callbackExecutorGroup);
            }
            Executor compressionExecutor = this._customCompressionExecutor;
            if (this._useClientCompression && compressionExecutor == null) {
                LOG.warn("No Compression executor is provided to HttpClientFactory, using it's own compression executor.");
                ExecutorService customCompressionExecutor = Executors.newCachedThreadPool();
                compressionExecutor = customCompressionExecutor;
                executorsToShutDown.add(customCompressionExecutor);
            }
            EventProviderRegistry eventProviderRegistry2 = eventProviderRegistry = this._eventProviderRegistry == null ? new EventProviderRegistry() : this._eventProviderRegistry;
            if (this._usePipelineV2 && this._pipelineV2MinimumMaturityLevel > 1) {
                LOG.warn("Disabling Pipeline V2, Since Pegasus Pipeline V2 Maturity Level is below the configured level.");
                this._usePipelineV2 = false;
            }
            return new HttpClientFactory(this._filters, eventLoopGroup, this._shutdownFactory, scheduledExecutorService, this._shutdownExecutor, callbackExecutorGroup, this._shutdownCallbackExecutor, this._jmxManager, this._requestCompressionThresholdDefault, this._requestCompressionConfigs, this._responseCompressionConfigs, compressionExecutor, this._defaultHttpVersion, this._shareConnection, eventProviderRegistry, this._enableSSLSessionResumption, this._usePipelineV2, executorsToShutDown, this._connectTimeout, this._sslHandShakeTimeout, this._channelPoolWaiterTimeout);
        }
    }
}

