/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.client.common;

import com.linkedin.common.callback.Callback;
import com.linkedin.r2.RetriableRequestException;
import com.linkedin.r2.transport.http.client.AsyncPool;
import com.linkedin.r2.transport.http.client.AsyncPoolLifecycleStats;
import com.linkedin.r2.transport.http.client.PoolStats;
import com.linkedin.r2.transport.http.client.stream.http.HttpNettyStreamClient;
import com.linkedin.util.clock.Clock;
import com.linkedin.util.clock.SystemClock;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.channel.group.ChannelGroup;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.ConnectException;
import java.net.SocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelPoolLifecycle
implements AsyncPool.Lifecycle<Channel> {
    private static final Logger LOG = LoggerFactory.getLogger(ChannelPoolLifecycle.class);
    public static final AttributeKey<Long> CHANNEL_CREATION_TIME_KEY = AttributeKey.valueOf((String)"channelCreationTime");
    public static final int MAX_PERIOD_BEFORE_RETRY_CONNECTIONS = 5000;
    public static final int INITIAL_PERIOD_BEFORE_RETRY_CONNECTIONS = 100;
    private static final AsyncPoolLifecycleStats DEFAULT_LIFECYCLE_STATS = new AsyncPoolLifecycleStats(0.0, 0L, 0L, 0L);
    private final Clock _clock = SystemClock.instance();
    public static final String CHANNELPOOL_SSL_CALLBACK_HANDLER = "channelPoolSslCallbackHandler";
    private final SocketAddress _remoteAddress;
    private final Bootstrap _bootstrap;
    private final ChannelGroup _channelGroup;
    private final boolean _tcpNoDelay;

    public ChannelPoolLifecycle(SocketAddress address, Bootstrap bootstrap, ChannelGroup channelGroup, boolean tcpNoDelay) {
        this._remoteAddress = address;
        this._bootstrap = bootstrap;
        this._channelGroup = channelGroup;
        this._tcpNoDelay = tcpNoDelay;
    }

    public void create(final Callback<Channel> channelCallback) {
        this._bootstrap.connect(this._remoteAddress).addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> {
            if (!channelFuture.isSuccess()) {
                this.onError(channelCallback, channelFuture.cause());
                return;
            }
            final Channel c = channelFuture.channel();
            c.attr(CHANNEL_CREATION_TIME_KEY).set((Object)this._clock.currentTimeMillis());
            if (this._tcpNoDelay) {
                c.config().setOption(ChannelOption.TCP_NODELAY, (Object)true);
            }
            this._channelGroup.add((Object)c);
            if (c.pipeline().get("sslHandler") == null) {
                channelCallback.onSuccess((Object)c);
                return;
            }
            c.pipeline().addAfter("sslHandler", CHANNELPOOL_SSL_CALLBACK_HANDLER, (ChannelHandler)new ChannelDuplexHandler(){

                public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
                    if (evt == SslHandshakeCompletionEvent.SUCCESS) {
                        channelCallback.onSuccess((Object)c);
                        c.pipeline().remove(ChannelPoolLifecycle.CHANNELPOOL_SSL_CALLBACK_HANDLER);
                    } else if (evt instanceof SslHandshakeCompletionEvent) {
                        Throwable sslException = ((SslHandshakeCompletionEvent)evt).cause();
                        ChannelPoolLifecycle.this.onError((Callback<Channel>)channelCallback, sslException);
                    }
                    ctx.fireUserEventTriggered(evt);
                }
            });
        }));
    }

    private void onError(Callback<Channel> channelCallback, Throwable cause) {
        LOG.warn("Failed to create channel, remote={}", (Object)this._remoteAddress, (Object)cause);
        if (cause instanceof ConnectException) {
            channelCallback.onError((Throwable)new RetriableRequestException(cause));
        } else {
            channelCallback.onError((Throwable)HttpNettyStreamClient.toException(cause));
        }
    }

    public boolean validateGet(Channel c) {
        return c.isActive();
    }

    public boolean validatePut(Channel c) {
        return c.isActive();
    }

    public void destroy(Channel channel, boolean error, Callback<Channel> channelCallback) {
        if (channel.isOpen()) {
            channel.close().addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> {
                if (channelFuture.isSuccess()) {
                    channelCallback.onSuccess((Object)channelFuture.channel());
                } else {
                    Throwable cause = channelFuture.cause();
                    LOG.warn("Failed to destroy channel, remote={}", (Object)this._remoteAddress, (Object)cause);
                    channelCallback.onError((Throwable)HttpNettyStreamClient.toException(cause));
                }
            }));
        } else {
            channelCallback.onSuccess((Object)channel);
        }
    }

    public PoolStats.LifecycleStats getStats() {
        return DEFAULT_LIFECYCLE_STATS;
    }
}

