/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.client.common;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.util.None;
import com.linkedin.r2.netty.client.http.HttpChannelPoolFactory;
import com.linkedin.r2.netty.client.http2.Http2ChannelPoolFactory;
import com.linkedin.r2.transport.http.client.common.ChannelPoolFactory;
import com.linkedin.r2.transport.http.client.common.ChannelPoolManager;
import com.linkedin.r2.transport.http.client.common.ChannelPoolManagerFactory;
import com.linkedin.r2.transport.http.client.common.ChannelPoolManagerImpl;
import com.linkedin.r2.transport.http.client.common.ChannelPoolManagerKey;
import com.linkedin.r2.transport.http.client.rest.HttpNettyChannelPoolFactory;
import com.linkedin.r2.transport.http.client.stream.http.HttpNettyStreamChannelPoolFactory;
import com.linkedin.r2.transport.http.client.stream.http2.Http2NettyStreamChannelPoolFactory;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.util.concurrent.EventExecutor;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelPoolManagerFactoryImpl
implements ChannelPoolManagerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ChannelPoolManagerFactoryImpl.class);
    private static final int MAX_INITIAL_LINE_LENGTH = 4096;
    private final EventLoopGroup _eventLoopGroup;
    private final ScheduledExecutorService _scheduler;
    private final boolean _enableSSLSessionResumption;
    private final boolean _usePipelineV2;
    private final int _channelPoolWaiterTimeout;
    private final int _connectTimeout;
    private final int _sslHandShakeTimeout;

    public ChannelPoolManagerFactoryImpl(EventLoopGroup eventLoopGroup, ScheduledExecutorService scheduler, boolean enableSSLSessionResumption, boolean usePipelineV2, int channelPoolWaiterTimeout, int connectTimeout, int sslHandShakeTimeout) {
        this._eventLoopGroup = eventLoopGroup;
        this._scheduler = scheduler;
        this._enableSSLSessionResumption = enableSSLSessionResumption;
        this._usePipelineV2 = usePipelineV2;
        this._channelPoolWaiterTimeout = channelPoolWaiterTimeout;
        this._connectTimeout = connectTimeout;
        this._sslHandShakeTimeout = sslHandShakeTimeout;
    }

    @Override
    public ChannelPoolManager buildRest(ChannelPoolManagerKey channelPoolManagerKey) {
        DefaultChannelGroup channelGroup = new DefaultChannelGroup("R2 client channels", (EventExecutor)this._eventLoopGroup.next());
        if (channelPoolManagerKey.getMaxResponseSize() > Integer.MAX_VALUE) {
            LOG.warn("The configured max response size {} has exceeded the max value allowed {} for the HTTP Rest client. Consider using the streaming implementation instead.", (Object)channelPoolManagerKey.getMaxResponseSize(), (Object)Integer.MAX_VALUE);
        }
        return new ChannelPoolManagerImpl(new HttpNettyChannelPoolFactory(channelPoolManagerKey.getMaxPoolSize(), channelPoolManagerKey.getIdleTimeout(), channelPoolManagerKey.getPoolWaiterSize(), channelPoolManagerKey.getStrategy(), channelPoolManagerKey.getMinPoolSize(), this._eventLoopGroup, channelPoolManagerKey.getSslContext(), channelPoolManagerKey.getSslParameters(), channelPoolManagerKey.getMaxHeaderSize(), channelPoolManagerKey.getMaxChunkSize(), (int)channelPoolManagerKey.getMaxResponseSize(), this._scheduler, channelPoolManagerKey.getMaxConcurrentConnectionInitializations(), this._enableSSLSessionResumption, (ChannelGroup)channelGroup, this._channelPoolWaiterTimeout, this._connectTimeout, this._sslHandShakeTimeout), channelPoolManagerKey.getName(), (ChannelGroup)channelGroup, this._scheduler);
    }

    @Override
    public ChannelPoolManager buildStream(ChannelPoolManagerKey channelPoolManagerKey) {
        DefaultChannelGroup channelGroup = new DefaultChannelGroup("R2 client channels", (EventExecutor)this._eventLoopGroup.next());
        ChannelPoolFactory channelPoolFactory = this._usePipelineV2 ? new HttpChannelPoolFactory(this._scheduler, this._eventLoopGroup, (ChannelGroup)channelGroup, channelPoolManagerKey.getStrategy(), channelPoolManagerKey.getSslContext(), channelPoolManagerKey.getSslParameters(), channelPoolManagerKey.getMaxPoolSize(), channelPoolManagerKey.getMinPoolSize(), channelPoolManagerKey.getPoolWaiterSize(), 4096, channelPoolManagerKey.getMaxHeaderSize(), channelPoolManagerKey.getMaxChunkSize(), channelPoolManagerKey.getMaxConcurrentConnectionInitializations(), channelPoolManagerKey.getIdleTimeout(), channelPoolManagerKey.getMaxResponseSize(), channelPoolManagerKey.isTcpNoDelay(), this._enableSSLSessionResumption, this._channelPoolWaiterTimeout, this._connectTimeout, this._sslHandShakeTimeout) : new HttpNettyStreamChannelPoolFactory(channelPoolManagerKey.getMaxPoolSize(), channelPoolManagerKey.getIdleTimeout(), channelPoolManagerKey.getPoolWaiterSize(), channelPoolManagerKey.getStrategy(), channelPoolManagerKey.getMinPoolSize(), channelPoolManagerKey.isTcpNoDelay(), this._scheduler, channelPoolManagerKey.getMaxConcurrentConnectionInitializations(), channelPoolManagerKey.getSslContext(), channelPoolManagerKey.getSslParameters(), channelPoolManagerKey.getMaxHeaderSize(), channelPoolManagerKey.getMaxChunkSize(), channelPoolManagerKey.getMaxResponseSize(), this._enableSSLSessionResumption, this._eventLoopGroup, (ChannelGroup)channelGroup, this._channelPoolWaiterTimeout, this._connectTimeout, this._sslHandShakeTimeout);
        return new ChannelPoolManagerImpl(channelPoolFactory, channelPoolManagerKey.getName() + "-Stream", (ChannelGroup)channelGroup, this._scheduler);
    }

    @Override
    public ChannelPoolManager buildHttp2Stream(ChannelPoolManagerKey channelPoolManagerKey) {
        DefaultChannelGroup channelGroup = new DefaultChannelGroup("R2 client channels", (EventExecutor)this._eventLoopGroup.next());
        ChannelPoolFactory channelPoolFactory = this._usePipelineV2 ? new Http2ChannelPoolFactory(this._scheduler, this._eventLoopGroup, (ChannelGroup)channelGroup, channelPoolManagerKey.getStrategy(), channelPoolManagerKey.getSslContext(), channelPoolManagerKey.getSslParameters(), channelPoolManagerKey.getMaxPoolSize(), channelPoolManagerKey.getMinPoolSize(), channelPoolManagerKey.getPoolWaiterSize(), 4096, channelPoolManagerKey.getMaxHeaderSize(), channelPoolManagerKey.getMaxChunkSize(), channelPoolManagerKey.getIdleTimeout(), channelPoolManagerKey.getMaxResponseSize(), channelPoolManagerKey.isTcpNoDelay(), this._enableSSLSessionResumption, this._connectTimeout, this._sslHandShakeTimeout) : new Http2NettyStreamChannelPoolFactory(channelPoolManagerKey.getIdleTimeout(), channelPoolManagerKey.getPoolWaiterSize(), channelPoolManagerKey.getMinPoolSize(), channelPoolManagerKey.isTcpNoDelay(), this._scheduler, channelPoolManagerKey.getSslContext(), channelPoolManagerKey.getSslParameters(), channelPoolManagerKey.getGracefulShutdownTimeout(), channelPoolManagerKey.getMaxHeaderSize(), channelPoolManagerKey.getMaxChunkSize(), channelPoolManagerKey.getMaxResponseSize(), this._enableSSLSessionResumption, this._eventLoopGroup, (ChannelGroup)channelGroup, this._connectTimeout, this._sslHandShakeTimeout);
        return new ChannelPoolManagerImpl(channelPoolFactory, channelPoolManagerKey.getName() + "-HTTP/2-Stream", (ChannelGroup)channelGroup, this._scheduler);
    }

    @Override
    public void shutdown(Callback<None> callback) {
        callback.onSuccess((Object)None.none());
    }
}

