/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.client.common;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.callback.Callbacks;
import com.linkedin.common.util.None;
import com.linkedin.r2.transport.http.client.AsyncPool;
import com.linkedin.r2.transport.http.client.PoolStats;
import com.linkedin.r2.transport.http.client.TimeoutCallback;
import com.linkedin.r2.transport.http.client.common.ChannelPoolFactory;
import com.linkedin.r2.transport.http.client.common.ChannelPoolManager;
import com.linkedin.r2.util.TimeoutRunnable;
import io.netty.channel.Channel;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelGroupFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelPoolManagerImpl
implements ChannelPoolManager {
    private static final Logger LOG = LoggerFactory.getLogger(ChannelPoolManagerImpl.class);
    public static final String BASE_NAME = "ChannelPools";
    private final Object _mutex = new Object();
    private final ConcurrentMap<SocketAddress, AsyncPool<Channel>> _pool = new ConcurrentHashMap<SocketAddress, AsyncPool<Channel>>(256, 0.75f, 1);
    private final ChannelGroup _allChannels;
    private ScheduledExecutorService _scheduler;
    private State _state = State.RUNNING;
    private final ChannelPoolFactory _channelPoolFactory;
    private final String _name;

    public ChannelPoolManagerImpl(ChannelPoolFactory channelPoolFactory, ChannelGroup allChannels, ScheduledExecutorService scheduler) {
        this(channelPoolFactory, "noNameSpecifiedClientChannelPools", allChannels, scheduler);
    }

    public ChannelPoolManagerImpl(ChannelPoolFactory channelPoolFactory, String name, ChannelGroup allChannels, ScheduledExecutorService scheduler) {
        this._channelPoolFactory = channelPoolFactory;
        this._name = name;
        this._allChannels = allChannels;
        this._scheduler = scheduler;
    }

    @Override
    public void shutdown(final Callback<None> callback, final Runnable callbackStopRequest, final Runnable callbackShutdown, long shutdownTimeout) {
        final long deadline = System.currentTimeMillis() + shutdownTimeout;
        TimeoutCallback closeChannels = new TimeoutCallback(this._scheduler, shutdownTimeout, TimeUnit.MILLISECONDS, (Callback)new Callback<None>(){

            private void finishShutdown() {
                callbackStopRequest.run();
                ChannelPoolManagerImpl.this.cancelWaiters();
                TimeoutRunnable afterClose = new TimeoutRunnable(ChannelPoolManagerImpl.this._scheduler, deadline - System.currentTimeMillis(), TimeUnit.MILLISECONDS, () -> {
                    callbackShutdown.run();
                    LOG.info("Shutdown complete");
                    callback.onSuccess((Object)None.none());
                }, "Timed out waiting for channels to close, continuing shutdown");
                ChannelPoolManagerImpl.this._allChannels.close().addListener((GenericFutureListener)((ChannelGroupFutureListener)channelGroupFuture -> {
                    if (!channelGroupFuture.isSuccess()) {
                        LOG.warn("Failed to close some connections, ignoring");
                    }
                    afterClose.run();
                }));
            }

            public void onSuccess(None none) {
                LOG.info("All connection pools shut down, closing all channels");
                this.finishShutdown();
            }

            public void onError(Throwable e) {
                LOG.warn("Error shutting down HTTP connection pools, ignoring and continuing shutdown", e);
                this.finishShutdown();
            }
        }, "Connection pool shutdown timeout exceeded");
        this.shutdownPool((Callback<None>)closeChannels);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownPool(final Callback<None> callback) {
        Collection pools;
        State state;
        Object object = this._mutex;
        synchronized (object) {
            state = this._state;
            pools = this._pool.values();
            if (state == State.RUNNING) {
                this._state = State.SHUTTING_DOWN;
            }
        }
        if (state != State.RUNNING) {
            callback.onError((Throwable)new IllegalStateException("ChannelPoolManager is " + (Object)((Object)state)));
            return;
        }
        LOG.info("Shutting down {} connection pools", (Object)pools.size());
        Callback poolCallback = Callbacks.countDown((Callback)new Callback<None>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSuccess(None none) {
                Object object = ChannelPoolManagerImpl.this._mutex;
                synchronized (object) {
                    ChannelPoolManagerImpl.this._state = State.SHUTDOWN;
                }
                LOG.info("All connection pools shutdown");
                callback.onSuccess((Object)None.none());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onError(Throwable e) {
                Object object = ChannelPoolManagerImpl.this._mutex;
                synchronized (object) {
                    ChannelPoolManagerImpl.this._state = State.SHUTDOWN;
                }
                LOG.error("Error shutting down connection pools", e);
                callback.onError(e);
            }
        }, (int)pools.size());
        for (AsyncPool pool : pools) {
            pool.shutdown(poolCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Callback<Channel>> cancelWaiters() {
        Collection pools;
        ArrayList<Callback<Channel>> cancelled = new ArrayList<Callback<Channel>>();
        Iterator iterator = this._mutex;
        synchronized (iterator) {
            pools = this._pool.values();
        }
        for (AsyncPool pool : pools) {
            cancelled.addAll(pool.cancelWaiters());
        }
        return cancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AsyncPool<Channel> getPoolForAddress(SocketAddress address) throws IllegalStateException {
        AsyncPool pool = (AsyncPool)this._pool.get(address);
        if (pool != null) {
            return pool;
        }
        Object object = this._mutex;
        synchronized (object) {
            if (this._state != State.RUNNING) {
                throw new IllegalStateException("ChannelPoolManager is shutting down");
            }
            pool = (AsyncPool)this._pool.get(address);
            if (pool == null) {
                pool = this._channelPoolFactory.getPool(address);
                pool.start();
                this._pool.put(address, pool);
            }
        }
        return pool;
    }

    @Override
    public Map<String, PoolStats> getPoolStats() {
        HashMap<String, PoolStats> stats = new HashMap<String, PoolStats>();
        for (AsyncPool pool : this._pool.values()) {
            stats.put(pool.getName(), pool.getStats());
        }
        return stats;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public ChannelGroup getAllChannels() {
        return this._allChannels;
    }

    private static enum State {
        RUNNING,
        SHUTTING_DOWN,
        SHUTDOWN;

    }
}

