/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.client.common;

import com.linkedin.r2.transport.http.client.AsyncPoolImpl;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;

public class ChannelPoolManagerKey {
    private final SSLContext _sslContext;
    private final SSLParameters _sslParameters;
    private final int _gracefulShutdownTimeout;
    private final long _idleTimeout;
    private final long _sslIdleTimeout;
    private final int _maxHeaderSize;
    private final int _maxChunkSize;
    private final long _maxResponseSize;
    private final int _maxPoolSize;
    private final int _minPoolSize;
    private final int _maxConcurrentConnectionInitializations;
    private final int _poolWaiterSize;
    private final AsyncPoolImpl.Strategy _strategy;
    private final boolean _tcpNoDelay;
    private final String _poolStatsNamePrefix;

    public ChannelPoolManagerKey(SSLContext sslContext, SSLParameters sslParameters, int gracefulShutdownTimeout, long idleTimeout, long sslIdleTimeout, int maxHeaderSize, int maxChunkSize, long maxResponseSize, int maxPoolSize, int minPoolSize, int maxConcurrentConnectionInitializations, int poolWaiterSize, AsyncPoolImpl.Strategy strategy, boolean tcpNoDelay, String poolStatsNamePrefix) {
        this._sslContext = sslContext;
        this._sslParameters = sslParameters;
        this._gracefulShutdownTimeout = gracefulShutdownTimeout;
        this._idleTimeout = idleTimeout;
        this._sslIdleTimeout = sslIdleTimeout;
        this._maxHeaderSize = maxHeaderSize;
        this._maxChunkSize = maxChunkSize;
        this._maxResponseSize = maxResponseSize;
        this._maxPoolSize = maxPoolSize;
        this._minPoolSize = minPoolSize;
        this._maxConcurrentConnectionInitializations = maxConcurrentConnectionInitializations;
        this._poolWaiterSize = poolWaiterSize;
        this._strategy = strategy;
        this._tcpNoDelay = tcpNoDelay;
        this._poolStatsNamePrefix = poolStatsNamePrefix;
    }

    private boolean isSsl() {
        return this._sslContext != null && this._sslParameters != null;
    }

    public String getName() {
        return this._poolStatsNamePrefix + " " + String.valueOf(this.uniqueKeyBasedOnProperties()) + " " + (this.isSsl() ? "SSL" : "");
    }

    private int uniqueKeyBasedOnProperties() {
        int result = this._gracefulShutdownTimeout;
        result = 31 * result + (int)(this._idleTimeout ^ this._idleTimeout >>> 32);
        result = 31 * result + (int)(this._sslIdleTimeout ^ this._sslIdleTimeout >>> 32);
        result = 31 * result + this._maxHeaderSize;
        result = 31 * result + this._maxChunkSize;
        result = 31 * result + (int)(this._maxResponseSize ^ this._maxResponseSize >>> 32);
        result = 31 * result + this._maxPoolSize;
        result = 31 * result + this._minPoolSize;
        result = 31 * result + this._maxConcurrentConnectionInitializations;
        result = 31 * result + this._poolWaiterSize;
        result = 31 * result + (this._strategy != null ? this._strategy.toString().hashCode() : 0);
        result = 31 * result + (this._tcpNoDelay ? 1 : 0);
        result = 31 * result + (this.isSsl() ? 1 : 0);
        result = 31 * result + (this._poolStatsNamePrefix != null ? this._poolStatsNamePrefix.hashCode() : 0);
        return result;
    }

    public SSLContext getSslContext() {
        return this._sslContext;
    }

    public SSLParameters getSslParameters() {
        return this._sslParameters;
    }

    public int getGracefulShutdownTimeout() {
        return this._gracefulShutdownTimeout;
    }

    public long getIdleTimeout() {
        return this.isSsl() ? this._sslIdleTimeout : this._idleTimeout;
    }

    public int getMaxHeaderSize() {
        return this._maxHeaderSize;
    }

    public int getMaxChunkSize() {
        return this._maxChunkSize;
    }

    public long getMaxResponseSize() {
        return this._maxResponseSize;
    }

    public int getMaxPoolSize() {
        return this._maxPoolSize;
    }

    public int getMinPoolSize() {
        return this._minPoolSize;
    }

    public int getMaxConcurrentConnectionInitializations() {
        return this._maxConcurrentConnectionInitializations;
    }

    public int getPoolWaiterSize() {
        return this._poolWaiterSize;
    }

    public AsyncPoolImpl.Strategy getStrategy() {
        return this._strategy;
    }

    public boolean isTcpNoDelay() {
        return this._tcpNoDelay;
    }

    public String getPoolStatsNamePrefix() {
        return this._poolStatsNamePrefix;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChannelPoolManagerKey)) {
            return false;
        }
        ChannelPoolManagerKey that = (ChannelPoolManagerKey)o;
        if (this._gracefulShutdownTimeout != that._gracefulShutdownTimeout) {
            return false;
        }
        if (this._idleTimeout != that._idleTimeout) {
            return false;
        }
        if (this._maxHeaderSize != that._maxHeaderSize) {
            return false;
        }
        if (this._maxChunkSize != that._maxChunkSize) {
            return false;
        }
        if (this._maxResponseSize != that._maxResponseSize) {
            return false;
        }
        if (this._maxPoolSize != that._maxPoolSize) {
            return false;
        }
        if (this._minPoolSize != that._minPoolSize) {
            return false;
        }
        if (this._maxConcurrentConnectionInitializations != that._maxConcurrentConnectionInitializations) {
            return false;
        }
        if (this._poolWaiterSize != that._poolWaiterSize) {
            return false;
        }
        if (this._tcpNoDelay != that._tcpNoDelay) {
            return false;
        }
        if (this.isSsl() != that.isSsl()) {
            return false;
        }
        if (this._strategy != that._strategy) {
            return false;
        }
        return this._poolStatsNamePrefix != null ? this._poolStatsNamePrefix.equals(that._poolStatsNamePrefix) : that._poolStatsNamePrefix == null;
    }

    public int hashCode() {
        return this.uniqueKeyBasedOnProperties();
    }
}

