/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.client.common;

import com.linkedin.r2.transport.http.client.AsyncPoolImpl;
import com.linkedin.r2.transport.http.client.HttpClientFactory;
import com.linkedin.r2.transport.http.client.common.ChannelPoolManagerKey;
import io.netty.util.internal.ObjectUtil;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;

public class ChannelPoolManagerKeyBuilder {
    private SSLContext _sslContext = null;
    private SSLParameters _sslParameters = null;
    private int _gracefulShutdownTimeout = 30000;
    private long _idleTimeout = 25000L;
    private long _sslIdleTimeout = 10500000L;
    private int _maxHeaderSize = 8192;
    private int _maxChunkSize = 8192;
    private long _maxResponseSize = 0x200000L;
    private int _maxPoolSize = 200;
    private int _minPoolSize = 0;
    private int _maxConcurrentConnectionInitializations = Integer.MAX_VALUE;
    private int _poolWaiterSize = Integer.MAX_VALUE;
    private AsyncPoolImpl.Strategy _strategy = HttpClientFactory.DEFAULT_POOL_STRATEGY;
    private boolean _tcpNoDelay = true;
    private String _poolStatsNamePrefix = "noSpecifiedNamePrefix";

    public ChannelPoolManagerKeyBuilder setSSLContext(SSLContext sslContext) {
        this._sslContext = sslContext;
        return this;
    }

    public ChannelPoolManagerKeyBuilder setSSLParameters(SSLParameters sslParameters) {
        this._sslParameters = sslParameters;
        return this;
    }

    public ChannelPoolManagerKeyBuilder setGracefulShutdownTimeout(int gracefulShutdownTimeout) {
        ObjectUtil.checkPositiveOrZero((int)gracefulShutdownTimeout, (String)"gracefulShutdownTimeout");
        this._gracefulShutdownTimeout = gracefulShutdownTimeout;
        return this;
    }

    public ChannelPoolManagerKeyBuilder setIdleTimeout(long idleTimeout) {
        ObjectUtil.checkPositive((long)idleTimeout, (String)"idleTimeout");
        this._idleTimeout = idleTimeout;
        return this;
    }

    public ChannelPoolManagerKeyBuilder setSslIdleTimeout(long sslIdleTimeout) {
        ObjectUtil.checkPositive((long)sslIdleTimeout, (String)"sslIdleTimeout");
        this._sslIdleTimeout = sslIdleTimeout;
        return this;
    }

    public ChannelPoolManagerKeyBuilder setMaxHeaderSize(int maxHeaderSize) {
        ObjectUtil.checkPositive((int)maxHeaderSize, (String)"maxHeaderSize");
        this._maxHeaderSize = maxHeaderSize;
        return this;
    }

    public ChannelPoolManagerKeyBuilder setMaxChunkSize(int maxChunkSize) {
        ObjectUtil.checkPositive((int)maxChunkSize, (String)"maxChunkSize");
        this._maxChunkSize = maxChunkSize;
        return this;
    }

    public ChannelPoolManagerKeyBuilder setMaxResponseSize(long maxResponseSize) {
        ObjectUtil.checkPositive((long)maxResponseSize, (String)"maxResponseSize");
        this._maxResponseSize = maxResponseSize;
        return this;
    }

    public ChannelPoolManagerKeyBuilder setMaxPoolSize(int maxPoolSize) {
        ObjectUtil.checkPositive((int)maxPoolSize, (String)"maxPoolSize");
        this._maxPoolSize = maxPoolSize;
        return this;
    }

    public ChannelPoolManagerKeyBuilder setMinPoolSize(int minPoolSize) {
        ObjectUtil.checkPositiveOrZero((int)minPoolSize, (String)"minPoolSize");
        this._minPoolSize = minPoolSize;
        return this;
    }

    public ChannelPoolManagerKeyBuilder setMaxConcurrentConnectionInitializations(int maxConcurrentConnectionInitializations) {
        ObjectUtil.checkPositive((int)maxConcurrentConnectionInitializations, (String)"maxConcurrentConnectionInitializations");
        this._maxConcurrentConnectionInitializations = maxConcurrentConnectionInitializations;
        return this;
    }

    public ChannelPoolManagerKeyBuilder setPoolWaiterSize(int poolWaiterSize) {
        ObjectUtil.checkPositiveOrZero((int)poolWaiterSize, (String)"poolWaiterSize");
        this._poolWaiterSize = poolWaiterSize;
        return this;
    }

    public ChannelPoolManagerKeyBuilder setStrategy(AsyncPoolImpl.Strategy strategy) {
        ObjectUtil.checkNotNull((Object)strategy, (String)"strategy");
        this._strategy = strategy;
        return this;
    }

    public ChannelPoolManagerKeyBuilder setPoolStatsNamePrefix(String poolStatsNamePrefix) {
        ObjectUtil.checkNotNull((Object)poolStatsNamePrefix, (String)"poolStatsNamePrefix");
        this._poolStatsNamePrefix = poolStatsNamePrefix;
        return this;
    }

    public ChannelPoolManagerKeyBuilder setTcpNoDelay(boolean tcpNoDelay) {
        this._tcpNoDelay = tcpNoDelay;
        return this;
    }

    public ChannelPoolManagerKey build() {
        return new ChannelPoolManagerKey(this._sslContext, this._sslParameters, this._gracefulShutdownTimeout, this._idleTimeout, this._sslIdleTimeout, this._maxHeaderSize, this._maxChunkSize, this._maxResponseSize, this._maxPoolSize, this._minPoolSize, this._maxConcurrentConnectionInitializations, this._poolWaiterSize, this._strategy, this._tcpNoDelay, this._poolStatsNamePrefix);
    }
}

