/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.client.common;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.callback.MultiCallback;
import com.linkedin.common.util.None;
import com.linkedin.r2.transport.http.client.AsyncPool;
import com.linkedin.r2.transport.http.client.PoolStats;
import com.linkedin.r2.transport.http.client.common.ChannelPoolManager;
import com.linkedin.r2.transport.http.client.common.ChannelPoolManagerFactory;
import com.linkedin.r2.transport.http.client.common.ChannelPoolManagerKey;
import io.netty.channel.Channel;
import io.netty.channel.group.ChannelGroup;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class ConnectionSharingChannelPoolManagerFactory
implements ChannelPoolManagerFactory {
    private final ChannelPoolManagerFactory _channelPoolManagerFactory;
    private final Map<ChannelPoolManagerKey, ChannelPoolManager> channelPoolManagerMapRest = new ConcurrentHashMap<ChannelPoolManagerKey, ChannelPoolManager>();
    private final Map<ChannelPoolManagerKey, ChannelPoolManager> channelPoolManagerMapStream = new ConcurrentHashMap<ChannelPoolManagerKey, ChannelPoolManager>();
    private final Map<ChannelPoolManagerKey, ChannelPoolManager> channelPoolManagerMapHttp2Stream = new ConcurrentHashMap<ChannelPoolManagerKey, ChannelPoolManager>();

    public ConnectionSharingChannelPoolManagerFactory(ChannelPoolManagerFactory channelPoolManagerFactory) {
        this._channelPoolManagerFactory = channelPoolManagerFactory;
    }

    @Override
    public ChannelPoolManager buildRest(ChannelPoolManagerKey channelPoolManagerKey) {
        return this.getSharedChannelPoolManager(this.channelPoolManagerMapRest, channelPoolManagerKey, this._channelPoolManagerFactory::buildRest);
    }

    @Override
    public ChannelPoolManager buildStream(ChannelPoolManagerKey channelPoolManagerKey) {
        return this.getSharedChannelPoolManager(this.channelPoolManagerMapStream, channelPoolManagerKey, this._channelPoolManagerFactory::buildStream);
    }

    @Override
    public ChannelPoolManager buildHttp2Stream(ChannelPoolManagerKey channelPoolManagerKey) {
        return this.getSharedChannelPoolManager(this.channelPoolManagerMapHttp2Stream, channelPoolManagerKey, this._channelPoolManagerFactory::buildHttp2Stream);
    }

    @Override
    public void shutdown(Callback<None> callback) {
        MultiCallback multiCallback = new MultiCallback(callback, 3);
        this.shutdownChannelPoolManagers((Callback<None>)multiCallback, this.channelPoolManagerMapRest);
        this.shutdownChannelPoolManagers((Callback<None>)multiCallback, this.channelPoolManagerMapStream);
        this.shutdownChannelPoolManagers((Callback<None>)multiCallback, this.channelPoolManagerMapHttp2Stream);
    }

    private void shutdownChannelPoolManagers(Callback<None> callback, Map<ChannelPoolManagerKey, ChannelPoolManager> channelPoolManagerMap) {
        if (channelPoolManagerMap.size() == 0) {
            callback.onSuccess((Object)None.none());
        } else {
            MultiCallback multiCallback = new MultiCallback(callback, channelPoolManagerMap.size());
            channelPoolManagerMap.forEach((channelPoolManagerKey, channelPoolManager) -> channelPoolManager.shutdown((Callback<None>)multiCallback, () -> {}, () -> {}, 1000L));
        }
    }

    private ChannelPoolManager getSharedChannelPoolManager(Map<ChannelPoolManagerKey, ChannelPoolManager> channelPoolManagerMap, ChannelPoolManagerKey channelPoolManagerKey, Function<ChannelPoolManagerKey, ChannelPoolManager> channelPoolManagerSupplier) {
        return new ShutdownDisabledChannelPoolManager(channelPoolManagerMap.computeIfAbsent(channelPoolManagerKey, channelPoolManagerSupplier));
    }

    private static class ShutdownDisabledChannelPoolManager
    implements ChannelPoolManager {
        private final ChannelPoolManager channelPoolManager;

        private ShutdownDisabledChannelPoolManager(ChannelPoolManager channelPoolManager) {
            this.channelPoolManager = channelPoolManager;
        }

        @Override
        public void shutdown(Callback<None> callback, Runnable callbackStopRequest, Runnable callbackShutdown, long shutdownTimeout) {
            callbackStopRequest.run();
            callbackShutdown.run();
            callback.onSuccess((Object)None.none());
        }

        @Override
        public Collection<Callback<Channel>> cancelWaiters() {
            return this.channelPoolManager.cancelWaiters();
        }

        @Override
        public AsyncPool<Channel> getPoolForAddress(SocketAddress address) throws IllegalStateException {
            return this.channelPoolManager.getPoolForAddress(address);
        }

        @Override
        public Map<String, PoolStats> getPoolStats() {
            return this.channelPoolManager.getPoolStats();
        }

        @Override
        public String getName() {
            return this.channelPoolManager.getName();
        }

        @Override
        public ChannelGroup getAllChannels() {
            return this.channelPoolManager.getAllChannels();
        }
    }
}

