/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.client.common;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.util.None;
import com.linkedin.r2.event.ChannelPoolEventProvider;
import com.linkedin.r2.event.EventProviderRegistry;
import com.linkedin.r2.transport.http.client.AsyncPool;
import com.linkedin.r2.transport.http.client.PoolStats;
import com.linkedin.r2.transport.http.client.common.ChannelPoolManager;
import com.linkedin.r2.transport.http.client.common.ChannelPoolManagerFactory;
import com.linkedin.r2.transport.http.client.common.ChannelPoolManagerKey;
import com.linkedin.r2.transport.http.common.HttpProtocolVersion;
import io.netty.channel.Channel;
import io.netty.channel.group.ChannelGroup;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;

public class EventAwareChannelPoolManagerFactory
implements ChannelPoolManagerFactory {
    private final ChannelPoolManagerFactory _channelPoolManagerFactory;
    private final EventProviderRegistry _eventProviderRegistry;

    public EventAwareChannelPoolManagerFactory(ChannelPoolManagerFactory channelPoolManagerFactory, EventProviderRegistry eventProviderRegistry) {
        this._channelPoolManagerFactory = channelPoolManagerFactory;
        this._eventProviderRegistry = eventProviderRegistry;
    }

    @Override
    public ChannelPoolManager buildRest(ChannelPoolManagerKey channelPoolManagerKey) {
        return this.doBuild(this._channelPoolManagerFactory::buildRest, channelPoolManagerKey, TransportMode.REST.isStream(), HttpProtocolVersion.HTTP_1_1);
    }

    @Override
    public ChannelPoolManager buildStream(ChannelPoolManagerKey channelPoolManagerKey) {
        return this.doBuild(this._channelPoolManagerFactory::buildStream, channelPoolManagerKey, TransportMode.STREAM.isStream(), HttpProtocolVersion.HTTP_1_1);
    }

    @Override
    public ChannelPoolManager buildHttp2Stream(ChannelPoolManagerKey channelPoolManagerKey) {
        return this.doBuild(this._channelPoolManagerFactory::buildHttp2Stream, channelPoolManagerKey, TransportMode.STREAM.isStream(), HttpProtocolVersion.HTTP_2);
    }

    @Override
    public void shutdown(Callback<None> callback) {
        this._channelPoolManagerFactory.shutdown(callback);
    }

    private ChannelPoolManager doBuild(Function<ChannelPoolManagerKey, ChannelPoolManager> channelPoolManagerSupplier, ChannelPoolManagerKey channelPoolManagerKey, boolean isStream, HttpProtocolVersion protocolVersion) {
        String clusterName = channelPoolManagerKey.getPoolStatsNamePrefix();
        boolean isSecure = channelPoolManagerKey.getSslContext() != null;
        EventProviderManager eventProviderManager = new EventProviderManager(channelPoolManagerSupplier.apply(channelPoolManagerKey), clusterName, isStream, isSecure, protocolVersion);
        this._eventProviderRegistry.registerChannelPoolEventProvider((ChannelPoolEventProvider)eventProviderManager);
        return eventProviderManager;
    }

    private class EventProviderManager
    implements ChannelPoolManager,
    ChannelPoolEventProvider {
        private final ChannelPoolManager _channelPoolManager;
        private final String _clusterName;
        private final boolean _isStream;
        private final boolean _isSecure;
        private final HttpProtocolVersion _protocolVersion;

        EventProviderManager(ChannelPoolManager channelPoolManager, String clusterName, boolean isStream, boolean isSecure, HttpProtocolVersion protocolVersion) {
            this._channelPoolManager = channelPoolManager;
            this._clusterName = clusterName;
            this._isStream = isStream;
            this._isSecure = isSecure;
            this._protocolVersion = protocolVersion;
        }

        @Override
        public void shutdown(Callback<None> callback, Runnable callbackStopRequest, Runnable callbackShutdown, long shutdownTimeout) {
            EventAwareChannelPoolManagerFactory.this._eventProviderRegistry.unregisterChannelPoolEventProvider((ChannelPoolEventProvider)this);
            this._channelPoolManager.shutdown(callback, callbackStopRequest, callbackShutdown, shutdownTimeout);
        }

        @Override
        public Collection<Callback<Channel>> cancelWaiters() {
            return this._channelPoolManager.cancelWaiters();
        }

        @Override
        public AsyncPool<Channel> getPoolForAddress(SocketAddress address) throws IllegalStateException {
            return this._channelPoolManager.getPoolForAddress(address);
        }

        @Override
        public Map<String, PoolStats> getPoolStats() {
            return this._channelPoolManager.getPoolStats();
        }

        @Override
        public String getName() {
            return this._channelPoolManager.getName();
        }

        @Override
        public ChannelGroup getAllChannels() {
            return this._channelPoolManager.getAllChannels();
        }

        public String clusterName() {
            return this._clusterName;
        }

        public boolean isStream() {
            return this._isStream;
        }

        public boolean isSecure() {
            return this._isSecure;
        }

        public HttpProtocolVersion protocolVersion() {
            return this._protocolVersion;
        }
    }

    private static enum TransportMode {
        STREAM(true),
        REST(false);

        private final boolean _isStream;

        private TransportMode(boolean isStream) {
            this._isStream = isStream;
        }

        boolean isStream() {
            return this._isStream;
        }
    }
}

