/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.client.rest;

import com.linkedin.common.stats.LongTracker;
import com.linkedin.common.stats.NoopLongTracker;
import com.linkedin.r2.netty.common.SslHandlerUtil;
import com.linkedin.r2.netty.handler.common.SessionResumptionSslHandler;
import com.linkedin.r2.transport.http.client.AsyncPool;
import com.linkedin.r2.transport.http.client.AsyncPoolImpl;
import com.linkedin.r2.transport.http.client.ExponentialBackOffRateLimiter;
import com.linkedin.r2.transport.http.client.RateLimiter;
import com.linkedin.r2.transport.http.client.common.ChannelPoolFactory;
import com.linkedin.r2.transport.http.client.common.ChannelPoolLifecycle;
import com.linkedin.r2.transport.http.client.rest.ChannelPoolHandler;
import com.linkedin.r2.transport.http.client.rest.RAPClientCodec;
import com.linkedin.r2.transport.http.client.rest.RAPResponseHandler;
import com.linkedin.util.clock.Clock;
import com.linkedin.util.clock.SystemClock;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpObjectAggregator;
import java.net.SocketAddress;
import java.util.concurrent.ScheduledExecutorService;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;

public class HttpNettyChannelPoolFactory
implements ChannelPoolFactory {
    private final Bootstrap _bootstrap;
    private final int _maxPoolSize;
    private final long _idleTimeout;
    private final int _maxPoolWaiterSize;
    private final AsyncPoolImpl.Strategy _strategy;
    private final int _minPoolSize;
    private final ChannelGroup _allChannels;
    private final ScheduledExecutorService _scheduler;
    private final int _maxConcurrentConnectionInitializations;
    private final int _channelPoolWaiterTimeout;

    public HttpNettyChannelPoolFactory(int maxPoolSize, long idleTimeout, int maxPoolWaiterSize, AsyncPoolImpl.Strategy strategy, int minPoolSize, EventLoopGroup eventLoopGroup, SSLContext sslContext, SSLParameters sslParameters, int maxHeaderSize, int maxChunkSize, int maxResponseSize, ScheduledExecutorService scheduler, int maxConcurrentConnectionInitializations, boolean enableSSLSessionResumption, ChannelGroup allChannels, int channelPoolWaiterTimeout, int connectTimeout, int sslHandShakeTimeout) {
        Bootstrap bootstrap;
        this._allChannels = allChannels;
        this._scheduler = scheduler;
        this._maxConcurrentConnectionInitializations = maxConcurrentConnectionInitializations;
        this._channelPoolWaiterTimeout = channelPoolWaiterTimeout;
        this._bootstrap = bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(eventLoopGroup)).channel(NioSocketChannel.class)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)connectTimeout)).handler((ChannelHandler)new HttpClientPipelineInitializer(sslContext, sslParameters, maxHeaderSize, maxChunkSize, maxResponseSize, enableSSLSessionResumption, sslHandShakeTimeout));
        this._maxPoolSize = maxPoolSize;
        this._idleTimeout = idleTimeout;
        this._maxPoolWaiterSize = maxPoolWaiterSize;
        this._strategy = strategy;
        this._minPoolSize = minPoolSize;
    }

    @Override
    public AsyncPool<Channel> getPool(SocketAddress address) {
        return new AsyncPoolImpl(address.toString(), (AsyncPool.Lifecycle)new ChannelPoolLifecycle(address, this._bootstrap, this._allChannels, false), this._maxPoolSize, this._idleTimeout, (long)this._channelPoolWaiterTimeout, this._scheduler, this._maxPoolWaiterSize, this._strategy, this._minPoolSize, (RateLimiter)new ExponentialBackOffRateLimiter(0L, 5000L, 100L, this._scheduler, this._maxConcurrentConnectionInitializations), (Clock)SystemClock.instance(), (LongTracker)NoopLongTracker.instance());
    }

    static class HttpClientPipelineInitializer
    extends ChannelInitializer<NioSocketChannel> {
        private final SSLContext _sslContext;
        private final SSLParameters _sslParameters;
        private final ChannelPoolHandler _handler = new ChannelPoolHandler();
        private final RAPResponseHandler _responseHandler = new RAPResponseHandler();
        private final int _maxHeaderSize;
        private final int _maxChunkSize;
        private final int _maxResponseSize;
        private final boolean _enableSSLSessionResumption;
        private final int _sslSessionTimeout;

        public HttpClientPipelineInitializer(SSLContext sslContext, SSLParameters sslParameters, int maxHeaderSize, int maxChunkSize, int maxResponseSize, boolean enableSSLSessionResumption, int sslSessionTimeout) {
            this._maxHeaderSize = maxHeaderSize;
            this._maxChunkSize = maxChunkSize;
            this._maxResponseSize = maxResponseSize;
            this._enableSSLSessionResumption = enableSSLSessionResumption;
            this._sslSessionTimeout = sslSessionTimeout;
            SslHandlerUtil.validateSslParameters(sslContext, sslParameters);
            this._sslContext = sslContext;
            this._sslParameters = sslParameters;
        }

        protected void initChannel(NioSocketChannel ch) throws Exception {
            if (this._sslContext != null) {
                ch.pipeline().addLast("SessionResumptionSslHandler", (ChannelHandler)new SessionResumptionSslHandler(this._sslContext, this._sslParameters, this._enableSSLSessionResumption, this._sslSessionTimeout));
            }
            ch.pipeline().addLast("codec", (ChannelHandler)new HttpClientCodec(4096, this._maxHeaderSize, this._maxChunkSize));
            ch.pipeline().addLast("dechunker", (ChannelHandler)new HttpObjectAggregator(this._maxResponseSize));
            ch.pipeline().addLast("rapiCodec", (ChannelHandler)new RAPClientCodec());
            ch.pipeline().addLast("responseHandler", (ChannelHandler)this._responseHandler);
            ch.pipeline().addLast("channelManager", (ChannelHandler)this._handler);
        }
    }
}

