/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.client.rest;

import com.linkedin.common.callback.Callback;
import com.linkedin.r2.message.Request;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestRequestBuilder;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.message.stream.StreamRequest;
import com.linkedin.r2.message.stream.StreamResponse;
import com.linkedin.r2.netty.common.NettyChannelAttributes;
import com.linkedin.r2.netty.common.NettyClientState;
import com.linkedin.r2.netty.handler.common.SslHandshakeTimingHandler;
import com.linkedin.r2.transport.common.WireAttributeHelper;
import com.linkedin.r2.transport.common.bridge.common.TransportCallback;
import com.linkedin.r2.transport.http.client.AbstractJmxManager;
import com.linkedin.r2.transport.http.client.AsyncPool;
import com.linkedin.r2.transport.http.client.TimeoutTransportCallback;
import com.linkedin.r2.transport.http.client.common.AbstractNettyClient;
import com.linkedin.r2.transport.http.client.common.ChannelPoolFactory;
import com.linkedin.r2.transport.http.client.common.ChannelPoolManager;
import com.linkedin.r2.transport.http.client.common.ErrorChannelFutureListener;
import com.linkedin.r2.transport.http.client.common.ssl.SslSessionValidator;
import com.linkedin.r2.transport.http.client.rest.ChannelPoolHandler;
import com.linkedin.r2.transport.http.client.rest.ExecutionCallback;
import com.linkedin.r2.transport.http.client.rest.RAPResponseHandler;
import com.linkedin.r2.transport.http.common.HttpProtocolVersion;
import com.linkedin.r2.util.Cancellable;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeoutException;

public class HttpNettyClient
extends AbstractNettyClient<RestRequest, RestResponse> {
    private final ExecutorService _callbackExecutors;

    public HttpNettyClient(EventLoopGroup eventLoopGroup, ScheduledExecutorService executor, long requestTimeout, long shutdownTimeout, ExecutorService callbackExecutors, AbstractJmxManager jmxManager, ChannelPoolManager channelPoolManager, ChannelPoolManager sslChannelPoolManager) {
        super(executor, requestTimeout, shutdownTimeout, jmxManager, channelPoolManager, sslChannelPoolManager);
        this._callbackExecutors = callbackExecutors == null ? eventLoopGroup : callbackExecutors;
    }

    public HttpNettyClient(ChannelPoolFactory factory, ScheduledExecutorService executor, int requestTimeout, int shutdownTimeout) {
        super(factory, executor, requestTimeout, shutdownTimeout);
        this._callbackExecutors = new DefaultEventExecutorGroup(1);
    }

    @Override
    public void streamRequest(StreamRequest request, RequestContext requestContext, Map<String, String> wireAttrs, TransportCallback<StreamResponse> callback) {
        throw new UnsupportedOperationException("Stream is not supported.");
    }

    @Override
    protected TransportCallback<RestResponse> getExecutionCallback(TransportCallback<RestResponse> callback) {
        return new ExecutionCallback<RestResponse>(this._callbackExecutors, callback);
    }

    @Override
    protected void doWriteRequest(RestRequest request, final RequestContext requestContext, SocketAddress address, Map<String, String> wireAttrs, final TimeoutTransportCallback<RestResponse> callback, long requestTimeout) {
        AsyncPool<Channel> pool;
        final RestRequest newRequest = ((RestRequestBuilder)new RestRequestBuilder(request).overwriteHeaders(WireAttributeHelper.toWireAttributes(wireAttrs))).build();
        requestContext.putLocalAttr("HTTP_PROTOCOL_VERSION", (Object)HttpProtocolVersion.HTTP_1_1);
        try {
            pool = this.getChannelPoolManagerPerRequest((Request)request).getPoolForAddress(address);
        }
        catch (IllegalStateException e) {
            HttpNettyClient.errorResponse(callback, e);
            return;
        }
        Cancellable pendingGet = pool.get((Callback)new Callback<Channel>(){

            public void onSuccess(Channel channel) {
                channel.attr(ChannelPoolHandler.CHANNEL_POOL_ATTR_KEY).set((Object)pool);
                callback.addTimeoutTask(() -> {
                    AsyncPool pool1 = (AsyncPool)channel.attr(ChannelPoolHandler.CHANNEL_POOL_ATTR_KEY).getAndSet(null);
                    if (pool1 != null) {
                        pool1.dispose((Object)channel);
                    }
                });
                TransportCallback sslTimingCallback = SslHandshakeTimingHandler.getSslTimingCallback(channel, requestContext, callback);
                channel.attr(RAPResponseHandler.CALLBACK_ATTR_KEY).set(sslTimingCallback);
                SslSessionValidator sslSessionValidator = (SslSessionValidator)requestContext.getLocalAttr("REQUESTED_SSL_SESSION_VALIDATOR");
                channel.attr(NettyChannelAttributes.SSL_SESSION_VALIDATOR).set((Object)sslSessionValidator);
                NettyClientState state = (NettyClientState)((Object)HttpNettyClient.this._state.get());
                if (state == NettyClientState.REQUESTS_STOPPING || state == NettyClientState.SHUTDOWN) {
                    AbstractNettyClient.errorResponse(sslTimingCallback, new TimeoutException("Operation did not complete before shutdown"));
                    AsyncPool pool2 = (AsyncPool)channel.attr(ChannelPoolHandler.CHANNEL_POOL_ATTR_KEY).getAndSet(null);
                    if (pool2 != null) {
                        pool2.put((Object)channel);
                    }
                    return;
                }
                channel.writeAndFlush((Object)newRequest).addListener((GenericFutureListener)new ErrorChannelFutureListener());
            }

            public void onError(Throwable e) {
                AbstractNettyClient.errorResponse(callback, e);
            }
        });
        if (pendingGet != null) {
            callback.addTimeoutTask(() -> ((Cancellable)pendingGet).cancel());
        }
    }
}

