/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.client.stream;

import com.linkedin.common.callback.Callback;
import com.linkedin.r2.message.Messages;
import com.linkedin.r2.message.Request;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.message.stream.StreamRequest;
import com.linkedin.r2.message.stream.StreamRequestBuilder;
import com.linkedin.r2.message.stream.StreamResponse;
import com.linkedin.r2.netty.callback.StreamExecutionCallback;
import com.linkedin.r2.transport.common.WireAttributeHelper;
import com.linkedin.r2.transport.common.bridge.common.TransportCallback;
import com.linkedin.r2.transport.http.client.AbstractJmxManager;
import com.linkedin.r2.transport.http.client.TimeoutTransportCallback;
import com.linkedin.r2.transport.http.client.common.AbstractNettyClient;
import com.linkedin.r2.transport.http.client.common.ChannelPoolFactory;
import com.linkedin.r2.transport.http.client.common.ChannelPoolManager;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;

public abstract class AbstractNettyStreamClient
extends AbstractNettyClient<StreamRequest, StreamResponse> {
    private final ExecutorService _callbackExecutors;

    public AbstractNettyStreamClient(EventLoopGroup eventLoopGroup, ScheduledExecutorService executor, long requestTimeout, long shutdownTimeout, ExecutorService callbackExecutors, AbstractJmxManager jmxManager, ChannelPoolManager channelPoolManager, ChannelPoolManager sslChannelPoolManager) {
        super(executor, requestTimeout, shutdownTimeout, jmxManager, channelPoolManager, sslChannelPoolManager);
        this._callbackExecutors = callbackExecutors == null ? eventLoopGroup : callbackExecutors;
    }

    public AbstractNettyStreamClient(ChannelPoolFactory factory, ScheduledExecutorService executor, int requestTimeout, int shutdownTimeout) {
        super(factory, executor, requestTimeout, shutdownTimeout);
        this._callbackExecutors = new DefaultEventExecutorGroup(1);
    }

    @Override
    public void restRequest(RestRequest request, RequestContext requestContext, Map<String, String> wireAttrs, TransportCallback<RestResponse> callback) {
        throw new UnsupportedOperationException("Rest is not supported.");
    }

    @Override
    protected TransportCallback<StreamResponse> getExecutionCallback(TransportCallback<StreamResponse> callback) {
        return new StreamExecutionCallback(this._callbackExecutors, callback);
    }

    protected abstract void doWriteRequestWithWireAttrHeaders(Request var1, RequestContext var2, SocketAddress var3, Map<String, String> var4, TimeoutTransportCallback<StreamResponse> var5, long var6);

    @Override
    protected void doWriteRequest(StreamRequest request, final RequestContext requestContext, final SocketAddress address, final Map<String, String> wireAttrs, final TimeoutTransportCallback<StreamResponse> callback, final long requestTimeout) {
        StreamRequest requestWithWireAttrHeaders = ((StreamRequestBuilder)request.builder().overwriteHeaders(WireAttributeHelper.toWireAttributes(wireAttrs))).build(request.getEntityStream());
        if (AbstractNettyStreamClient.isFullRequest(requestContext)) {
            Messages.toRestRequest((StreamRequest)requestWithWireAttrHeaders, (Callback)new Callback<RestRequest>(){

                public void onError(Throwable e) {
                    AbstractNettyClient.errorResponse(callback, e);
                }

                public void onSuccess(RestRequest restRequest) {
                    AbstractNettyStreamClient.this.doWriteRequestWithWireAttrHeaders((Request)restRequest, requestContext, address, wireAttrs, (TimeoutTransportCallback<StreamResponse>)callback, requestTimeout);
                }
            });
        } else {
            this.doWriteRequestWithWireAttrHeaders((Request)requestWithWireAttrHeaders, requestContext, address, wireAttrs, callback, requestTimeout);
        }
    }

    private static boolean isFullRequest(RequestContext requestContext) {
        Object isFull = requestContext.getLocalAttr("IS_FULL_REQUEST");
        return isFull != null && (Boolean)isFull != false;
    }
}

