/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.client.stream;

import com.linkedin.data.ByteString;
import com.linkedin.r2.message.stream.entitystream.ReadHandle;
import com.linkedin.r2.message.stream.entitystream.Reader;
import io.netty.channel.ChannelHandlerContext;

public class OrderedEntityStreamReader
implements Reader {
    private final ChannelHandlerContext _ctx;
    private final Reader _reader;
    private ReadHandle _rh;

    public OrderedEntityStreamReader(ChannelHandlerContext ctx, Reader reader) {
        this._ctx = ctx;
        this._reader = reader;
    }

    private void addToEventLoop(Runnable r) {
        this._ctx.executor().execute(r);
    }

    public void onInit(ReadHandle rh) {
        this._rh = rh;
        this.addToEventLoop(() -> this._reader.onInit(rh));
    }

    public void onDataAvailable(ByteString data) {
        this.addToEventLoop(() -> this._reader.onDataAvailable(data));
    }

    public void onDone() {
        this.addToEventLoop(() -> ((Reader)this._reader).onDone());
    }

    public void onError(Throwable e) {
        this.addToEventLoop(() -> this._reader.onError(e));
    }

    public void request(int maximumChunks) {
        this._rh.request(maximumChunks);
    }
}

