/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.client.stream.http;

import com.linkedin.r2.message.Response;
import com.linkedin.r2.message.stream.StreamResponse;
import com.linkedin.r2.message.stream.StreamResponseBuilder;
import com.linkedin.r2.transport.common.WireAttributeHelper;
import com.linkedin.r2.transport.common.bridge.common.TransportCallback;
import com.linkedin.r2.transport.common.bridge.common.TransportResponseImpl;
import com.linkedin.r2.transport.http.client.stream.http.HttpNettyStreamClient;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.AttributeKey;
import java.nio.channels.ClosedChannelException;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
class RAPStreamResponseHandler
extends SimpleChannelInboundHandler<StreamResponse> {
    private static Logger LOG = LoggerFactory.getLogger(RAPStreamResponseHandler.class);
    public static final AttributeKey<TransportCallback<StreamResponse>> CALLBACK_ATTR_KEY = AttributeKey.valueOf((String)"Callback");

    RAPStreamResponseHandler() {
    }

    protected void channelRead0(ChannelHandlerContext ctx, StreamResponse response) throws Exception {
        TreeMap headers = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        headers.putAll(response.getHeaders());
        Map wireAttrs = WireAttributeHelper.removeWireAttributes(headers);
        StreamResponse newResponse = ((StreamResponseBuilder)new StreamResponseBuilder((Response)response).unsafeSetHeaders(headers)).build(response.getEntityStream());
        TransportCallback callback = (TransportCallback)ctx.channel().attr(CALLBACK_ATTR_KEY).getAndSet(null);
        if (callback != null) {
            LOG.debug("{}: handling a response", (Object)ctx.channel().remoteAddress());
            callback.onResponse(TransportResponseImpl.success((Object)newResponse, (Map)wireAttrs));
        } else {
            LOG.debug("{}: dropped a response", (Object)ctx.channel().remoteAddress());
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        TransportCallback callback = (TransportCallback)ctx.channel().attr(CALLBACK_ATTR_KEY).getAndSet(null);
        if (callback != null) {
            LOG.debug(ctx.channel().remoteAddress() + ": exception on active channel", cause);
            callback.onResponse(TransportResponseImpl.error((Throwable)HttpNettyStreamClient.toException(cause), Collections.emptyMap()));
        } else {
            LOG.debug(ctx.channel().remoteAddress() + ": exception on potentially active channel", cause);
        }
        ctx.fireExceptionCaught(cause);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        TransportCallback callback = (TransportCallback)ctx.channel().attr(CALLBACK_ATTR_KEY).getAndSet(null);
        if (callback != null) {
            LOG.debug("{}: active channel closed", (Object)ctx.channel().remoteAddress());
            callback.onResponse(TransportResponseImpl.error((Throwable)new ClosedChannelException(), Collections.emptyMap()));
        } else {
            LOG.debug("{}: potentially idle channel closed", (Object)ctx.channel().remoteAddress());
        }
        ctx.fireChannelInactive();
    }
}

