/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.client.stream.http2;

import com.linkedin.r2.transport.http.client.stream.http2.Http2AlpnHandler;
import com.linkedin.r2.transport.http.client.stream.http2.Http2SchemeHandler;
import com.linkedin.r2.transport.http.client.stream.http2.Http2StreamCodec;
import com.linkedin.r2.transport.http.client.stream.http2.Http2StreamCodecBuilder;
import com.linkedin.r2.transport.http.client.stream.http2.Http2StreamResponseHandler;
import com.linkedin.r2.transport.http.client.stream.http2.Http2UpgradeHandler;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpClientUpgradeHandler;
import io.netty.handler.codec.http.HttpScheme;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.Http2ClientUpgradeCodec;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.SslContext;
import io.netty.util.AttributeKey;
import java.util.Arrays;
import java.util.HashSet;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Http2ClientPipelineInitializer
extends ChannelInitializer<NioSocketChannel> {
    private static final Logger LOG = LoggerFactory.getLogger(Http2ClientPipelineInitializer.class);
    private final SSLContext _sslContext;
    private final SSLParameters _sslParameters;
    private final int _maxHeaderSize;
    private final int _maxChunkSize;
    private final long _maxResponseSize;
    private final long _gracefulShutdownTimeout;
    private static final int MAX_CLIENT_UPGRADE_CONTENT_LENGTH = Integer.MAX_VALUE;
    private static final int MAX_INITIAL_LINE_LENGTH = 4096;
    private static final boolean IS_CLIENT = true;
    public static final AttributeKey<Http2Connection> HTTP2_CONNECTION_ATTR_KEY = AttributeKey.valueOf((String)"Http2Connection");
    public static final AttributeKey<Http2Connection.PropertyKey> CALLBACK_ATTR_KEY = AttributeKey.valueOf((String)"Callback");
    public static final AttributeKey<Http2Connection.PropertyKey> CHANNEL_POOL_HANDLE_ATTR_KEY = AttributeKey.valueOf((String)"Handle");
    private final boolean _enableSSLSessionResumption;
    private final int _sslHandShakeTimeout;

    public Http2ClientPipelineInitializer(SSLContext sslContext, SSLParameters sslParameters, int maxHeaderSize, int maxChunkSize, long maxResponseSize, long gracefulShutdownTimeout, boolean enableSSLSessionResumption, int sslHandShakeTimeout) {
        if (sslParameters != null) {
            if (sslContext == null) {
                throw new IllegalArgumentException("SSLParameters passed with no SSLContext");
            }
            SSLParameters supportedSSLParameters = sslContext.getSupportedSSLParameters();
            if (sslParameters.getCipherSuites() != null) {
                this.checkContained(supportedSSLParameters.getCipherSuites(), sslParameters.getCipherSuites(), "cipher suite");
            }
            if (sslParameters.getProtocols() != null) {
                this.checkContained(supportedSSLParameters.getProtocols(), sslParameters.getProtocols(), "protocol");
            }
        }
        this._sslContext = sslContext;
        this._sslParameters = sslParameters;
        this._maxHeaderSize = maxHeaderSize;
        this._maxChunkSize = maxChunkSize;
        this._maxResponseSize = maxResponseSize;
        this._gracefulShutdownTimeout = gracefulShutdownTimeout;
        this._enableSSLSessionResumption = enableSSLSessionResumption;
        this._sslHandShakeTimeout = sslHandShakeTimeout;
    }

    protected void initChannel(NioSocketChannel channel) throws Exception {
        DefaultHttp2Connection connection = new DefaultHttp2Connection(false);
        channel.attr(HTTP2_CONNECTION_ATTR_KEY).set((Object)connection);
        channel.attr(CALLBACK_ATTR_KEY).set((Object)connection.newKey());
        channel.attr(CHANNEL_POOL_HANDLE_ATTR_KEY).set((Object)connection.newKey());
        if (this._sslParameters == null) {
            this.configureHttpPipeline((Channel)channel, (Http2Connection)connection);
        } else {
            this.configureHttpsPipeline(channel, (Http2Connection)connection);
        }
    }

    private void configureHttpPipeline(Channel channel, Http2Connection connection) throws Exception {
        Http2StreamCodec http2Codec = new Http2StreamCodecBuilder().connection(connection).maxContentLength(this._maxResponseSize).gracefulShutdownTimeoutMillis(this._gracefulShutdownTimeout).build();
        HttpClientCodec sourceCodec = new HttpClientCodec(4096, this._maxHeaderSize, this._maxChunkSize);
        Http2ClientUpgradeCodec upgradeCodec = new Http2ClientUpgradeCodec((Http2ConnectionHandler)http2Codec);
        HttpClientUpgradeHandler upgradeHandler = new HttpClientUpgradeHandler((HttpClientUpgradeHandler.SourceCodec)sourceCodec, (HttpClientUpgradeHandler.UpgradeCodec)upgradeCodec, Integer.MAX_VALUE);
        Http2SchemeHandler schemeHandler = new Http2SchemeHandler(HttpScheme.HTTP.toString());
        Http2UpgradeHandler upgradeRequestHandler = new Http2UpgradeHandler();
        Http2StreamResponseHandler responseHandler = new Http2StreamResponseHandler();
        channel.pipeline().addLast("sourceCodec", (ChannelHandler)sourceCodec);
        channel.pipeline().addLast("upgradeHandler", (ChannelHandler)upgradeHandler);
        channel.pipeline().addLast("upgradeRequestHandler", (ChannelHandler)upgradeRequestHandler);
        channel.pipeline().addLast("schemeHandler", (ChannelHandler)schemeHandler);
        channel.pipeline().addLast("responseHandler", (ChannelHandler)responseHandler);
    }

    private void configureHttpsPipeline(NioSocketChannel ctx, Http2Connection connection) throws Exception {
        JdkSslContext context = new JdkSslContext(this._sslContext, true, Arrays.asList(this._sslParameters.getCipherSuites()), (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE, new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2", "http/1.1"}), this._sslParameters.getNeedClientAuth() ? ClientAuth.REQUIRE : ClientAuth.OPTIONAL);
        Http2StreamCodec http2Codec = new Http2StreamCodecBuilder().connection(connection).maxContentLength(this._maxResponseSize).gracefulShutdownTimeoutMillis(this._gracefulShutdownTimeout).build();
        Http2AlpnHandler alpnHandler = new Http2AlpnHandler((SslContext)context, http2Codec, this._enableSSLSessionResumption, this._sslHandShakeTimeout);
        Http2SchemeHandler schemeHandler = new Http2SchemeHandler(HttpScheme.HTTPS.toString());
        Http2StreamResponseHandler responseHandler = new Http2StreamResponseHandler();
        ctx.pipeline().addLast("alpnHandler", (ChannelHandler)alpnHandler);
        ctx.pipeline().addLast("schemeHandler", (ChannelHandler)schemeHandler);
        ctx.pipeline().addLast("responseHandler", (ChannelHandler)responseHandler);
    }

    private void checkContained(String[] containingArray, String[] containedArray, String valueName) {
        HashSet<String> containingSet = new HashSet<String>(Arrays.asList(containingArray));
        HashSet<String> containedSet = new HashSet<String>(Arrays.asList(containedArray));
        boolean changed = containedSet.removeAll(containingSet);
        if (!changed) {
            throw new IllegalArgumentException("None of the requested " + valueName + "s: " + containedSet + " are found in SSLContext");
        }
        if (!containedSet.isEmpty()) {
            for (String paramValue : containedSet) {
                LOG.warn("{} {} requested but not found in SSLContext", (Object)valueName, (Object)paramValue);
            }
        }
    }
}

