/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.client.stream.http2;

import com.linkedin.data.ByteString;
import com.linkedin.r2.RemoteInvocationException;
import com.linkedin.r2.message.Response;
import com.linkedin.r2.message.stream.StreamResponse;
import com.linkedin.r2.message.stream.StreamResponseBuilder;
import com.linkedin.r2.message.stream.entitystream.EntityStream;
import com.linkedin.r2.message.stream.entitystream.EntityStreams;
import com.linkedin.r2.message.stream.entitystream.WriteHandle;
import com.linkedin.r2.message.stream.entitystream.Writer;
import com.linkedin.r2.netty.handler.http2.Http2MessageDecoders;
import com.linkedin.r2.transport.common.bridge.common.ResponseWithCallback;
import com.linkedin.r2.transport.common.bridge.common.TransportCallback;
import com.linkedin.r2.transport.http.client.TimeoutAsyncPoolHandle;
import com.linkedin.r2.transport.http.client.stream.http2.Http2ClientPipelineInitializer;
import com.linkedin.r2.transport.http.client.stream.http2.Http2PipelinePropertyUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2EventAdapter;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2LifecycleManager;
import io.netty.handler.codec.http2.Http2LocalFlowController;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2Stream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Http2FrameListener
extends Http2EventAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(Http2FrameListener.class);
    private final Http2Connection _connection;
    private final Http2Connection.PropertyKey _writerKey;
    private final Http2LifecycleManager _lifecycleManager;
    private final long _maxContentLength;
    private final int _connectionWindowSizeDelta;
    private boolean _settingsReceived = false;
    private boolean _settingsAckReceived = false;
    private boolean _settingsCompleteEventFired = false;

    public Http2FrameListener(Http2Connection connection, Http2LifecycleManager lifecycleManager, long maxContentLength, int initialConnectionWindowSize) {
        if (initialConnectionWindowSize < 65535) {
            throw new IllegalArgumentException("Initial connection window size should be greater than or equal to the default window size 65535");
        }
        this._connection = connection;
        this._writerKey = connection.newKey();
        this._lifecycleManager = lifecycleManager;
        this._maxContentLength = maxContentLength;
        this._connectionWindowSizeDelta = initialConnectionWindowSize - 65535;
    }

    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) throws Http2Exception {
        this.onHeadersRead(ctx, streamId, headers, padding, endStream);
    }

    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endOfStream) throws Http2Exception {
        StreamResponse response;
        LOG.debug("Received HTTP/2 HEADERS frame, stream={}, end={}, headers={}, padding={}bytes", new Object[]{streamId, endOfStream, headers.size(), padding});
        if (streamId == 1) {
            return;
        }
        StreamResponseBuilder builder = Http2MessageDecoders.ResponseDecoder.buildStreamResponse(headers);
        TimeoutAsyncPoolHandle timeoutHandle = (TimeoutAsyncPoolHandle)Http2PipelinePropertyUtil.remove(ctx, this._connection, streamId, Http2ClientPipelineInitializer.CHANNEL_POOL_HANDLE_ATTR_KEY);
        if (timeoutHandle == null) {
            this._lifecycleManager.onError(ctx, false, (Throwable)Http2Exception.connectionError((Http2Error)Http2Error.PROTOCOL_ERROR, (String)"No channel pool handle is associated with this stream", (Object[])new Object[]{streamId}));
            return;
        }
        if (endOfStream) {
            response = builder.build(EntityStreams.emptyStream());
            timeoutHandle.release();
        } else {
            TimeoutBufferedWriter writer = new TimeoutBufferedWriter(ctx, streamId, this._maxContentLength, timeoutHandle);
            if (this._connection.stream(streamId).setProperty(this._writerKey, (Object)writer) != null) {
                this._lifecycleManager.onError(ctx, false, (Throwable)Http2Exception.connectionError((Http2Error)Http2Error.PROTOCOL_ERROR, (String)"Another writer has already been associated with current stream ID", (Object[])new Object[]{streamId}));
                return;
            }
            EntityStream entityStream = EntityStreams.newEntityStream((Writer)writer);
            response = builder.build(entityStream);
        }
        TransportCallback callback = (TransportCallback)Http2PipelinePropertyUtil.remove(ctx, this._connection, streamId, Http2ClientPipelineInitializer.CALLBACK_ATTR_KEY);
        if (callback != null) {
            ctx.fireChannelRead((Object)new ResponseWithCallback((Response)response, callback));
        }
    }

    public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
        LOG.debug("Received HTTP/2 DATA frame, stream={}, end={}, data={}bytes, padding={}bytes", new Object[]{streamId, endOfStream, data.readableBytes(), padding});
        if (streamId == 1) {
            return data.readableBytes() + padding;
        }
        TimeoutBufferedWriter writer = (TimeoutBufferedWriter)this._connection.stream(streamId).getProperty(this._writerKey);
        if (writer == null) {
            throw new IllegalStateException("No writer is associated with current stream ID " + streamId);
        }
        writer.onDataRead(data, endOfStream);
        if (endOfStream) {
            this._connection.stream(streamId).removeProperty(this._writerKey);
        }
        return padding;
    }

    public void onRstStreamRead(ChannelHandlerContext ctx, int streamId, long errorCode) throws Http2Exception {
        LOG.debug("Received HTTP/2 RST_STREAM frame, stream={}, error={}", (Object)streamId, (Object)Http2Error.valueOf((long)errorCode));
    }

    public void onSettingsRead(ChannelHandlerContext ctx, Http2Settings settings) throws Http2Exception {
        LOG.debug("Received HTTP/2 SETTINGS frame, settings={}", (Object)settings);
        ((Http2LocalFlowController)this._connection.local().flowController()).incrementWindowSize(this._connection.connectionStream(), this._connectionWindowSizeDelta);
        this._settingsReceived = true;
        this.checkAndTriggerSettingsCompleteEvent(ctx);
    }

    public void onSettingsAckRead(ChannelHandlerContext ctx) throws Http2Exception {
        LOG.debug("Received HTTP/2 SETTINGS_ACK frame");
        this._settingsAckReceived = true;
        this.checkAndTriggerSettingsCompleteEvent(ctx);
    }

    private void checkAndTriggerSettingsCompleteEvent(ChannelHandlerContext ctx) {
        if (this._settingsReceived && this._settingsAckReceived && !this._settingsCompleteEventFired) {
            ctx.fireUserEventTriggered((Object)FrameEvent.SETTINGS_COMPLETE);
            this._settingsCompleteEventFired = true;
        }
    }

    public void onWindowUpdateRead(ChannelHandlerContext ctx, int streamId, int windowSizeIncrement) throws Http2Exception {
        LOG.debug("Received HTTP/2 WINDOW_UPDATE frame, stream={}, increment={}", (Object)streamId, (Object)windowSizeIncrement);
    }

    class TimeoutBufferedWriter
    implements Writer {
        private final ChannelHandlerContext _ctx;
        private final int _streamId;
        private final long _maxContentLength;
        private final TimeoutAsyncPoolHandle<?> _timeoutPoolHandle;
        private WriteHandle _wh;
        private boolean _lastChunkReceived;
        private long _totalBytesWritten;
        private final Queue<ByteString> _buffer;
        private volatile Throwable _failureBeforeInit;

        TimeoutBufferedWriter(ChannelHandlerContext ctx, int streamId, long maxContentLength, TimeoutAsyncPoolHandle<?> timeoutPoolHandle) {
            this._ctx = ctx;
            this._streamId = streamId;
            this._maxContentLength = maxContentLength;
            this._timeoutPoolHandle = timeoutPoolHandle;
            this._failureBeforeInit = null;
            this._lastChunkReceived = false;
            this._totalBytesWritten = 0L;
            this._buffer = new LinkedList<ByteString>();
            this._timeoutPoolHandle.addTimeoutTask(() -> this._ctx.executor().execute(() -> {
                String message = String.format("Timeout while receiving the response entity, stream=%d, remote=%s", streamId, ctx.channel().remoteAddress());
                this.doResetAndNotify(new TimeoutException(message));
            }));
        }

        public void onInit(WriteHandle wh) {
            this._wh = wh;
        }

        public void onWritePossible() {
            if (this._failureBeforeInit != null) {
                this.doResetAndNotify(this._failureBeforeInit);
                return;
            }
            if (this._ctx.executor().inEventLoop()) {
                this.doWrite();
            } else {
                this._ctx.executor().execute(this::doWrite);
            }
        }

        public void onAbort(Throwable ex) {
            this.doReset();
        }

        public void onDataRead(ByteBuf data, boolean end) throws TooLongFrameException {
            if ((long)data.readableBytes() + this._totalBytesWritten > this._maxContentLength) {
                this.doResetAndNotify((Throwable)new TooLongFrameException("HTTP content length exceeded " + this._maxContentLength + " bytes."));
            } else {
                if (data.isReadable()) {
                    ByteString bytes;
                    ByteBufInputStream is = new ByteBufInputStream(data);
                    try {
                        bytes = ByteString.read((InputStream)is, (int)data.readableBytes());
                    }
                    catch (IOException ex) {
                        this.doResetAndNotify(ex);
                        return;
                    }
                    this._buffer.add(bytes);
                }
                if (end) {
                    this._lastChunkReceived = true;
                }
                if (this._wh != null) {
                    this.doWrite();
                }
            }
        }

        private void doResetAndNotify(Throwable cause) {
            this.doReset();
            if (this._wh != null) {
                this._wh.error((Throwable)new RemoteInvocationException(cause));
            } else {
                this._failureBeforeInit = cause;
            }
        }

        private void doReset() {
            Http2FrameListener.this._lifecycleManager.resetStream(this._ctx, this._streamId, Http2Error.CANCEL.code(), this._ctx.newPromise());
            this._ctx.flush();
            this._timeoutPoolHandle.release();
        }

        private void doWrite() {
            while (this._wh.remaining() > 0) {
                if (!this._buffer.isEmpty()) {
                    ByteString bytes = this._buffer.poll();
                    this._wh.write(bytes);
                    this._totalBytesWritten += (long)bytes.length();
                    try {
                        Http2Stream stream = Http2FrameListener.this._connection.stream(this._streamId);
                        ((Http2LocalFlowController)Http2FrameListener.this._connection.local().flowController()).consumeBytes(stream, bytes.length());
                        continue;
                    }
                    catch (Http2Exception e) {
                        this.doResetAndNotify(e);
                        return;
                    }
                    finally {
                        this._ctx.flush();
                        continue;
                    }
                }
                if (!this._lastChunkReceived) break;
                this._wh.done();
                this._timeoutPoolHandle.release();
                break;
            }
        }
    }

    public static enum FrameEvent {
        SETTINGS_COMPLETE;

    }
}

