/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.client.stream.http2;

import com.linkedin.common.stats.LongTracker;
import com.linkedin.common.stats.NoopLongTracker;
import com.linkedin.r2.transport.http.client.AsyncPool;
import com.linkedin.r2.transport.http.client.AsyncSharedPoolImpl;
import com.linkedin.r2.transport.http.client.NoopRateLimiter;
import com.linkedin.r2.transport.http.client.RateLimiter;
import com.linkedin.r2.transport.http.client.common.ChannelPoolFactory;
import com.linkedin.r2.transport.http.client.common.ChannelPoolLifecycle;
import com.linkedin.r2.transport.http.client.stream.http2.Http2ClientPipelineInitializer;
import com.linkedin.util.clock.Clock;
import com.linkedin.util.clock.SystemClock;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.net.SocketAddress;
import java.util.concurrent.ScheduledExecutorService;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;

public class Http2NettyStreamChannelPoolFactory
implements ChannelPoolFactory {
    private final Bootstrap _bootstrap;
    private final long _idleTimeout;
    private final int _maxPoolWaiterSize;
    private final boolean _tcpNoDelay;
    private final ChannelGroup _allChannels;
    private final ScheduledExecutorService _scheduler;
    private final boolean _createChannelImmediately;

    public Http2NettyStreamChannelPoolFactory(long idleTimeout, int maxPoolWaiterSize, int minPoolSize, boolean tcpNoDelay, ScheduledExecutorService scheduler, SSLContext sslContext, SSLParameters sslParameters, int gracefulShutdownTimeout, int maxHeaderSize, int maxChunkSize, long maxResponseSize, boolean enableSSLSessionResumption, EventLoopGroup eventLoopGroup, ChannelGroup channelGroup, int connectTimeout, int sslHandShakeTimeout) {
        Http2ClientPipelineInitializer initializer = new Http2ClientPipelineInitializer(sslContext, sslParameters, maxHeaderSize, maxChunkSize, maxResponseSize, gracefulShutdownTimeout, enableSSLSessionResumption, sslHandShakeTimeout);
        this._bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(eventLoopGroup)).channel(NioSocketChannel.class)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)connectTimeout)).handler((ChannelHandler)initializer);
        this._idleTimeout = idleTimeout;
        this._maxPoolWaiterSize = maxPoolWaiterSize;
        this._createChannelImmediately = minPoolSize > 0;
        this._tcpNoDelay = tcpNoDelay;
        this._allChannels = channelGroup;
        this._scheduler = scheduler;
    }

    @Override
    public AsyncPool<Channel> getPool(SocketAddress address) {
        return new AsyncSharedPoolImpl(address.toString(), (AsyncPool.Lifecycle)new ChannelPoolLifecycle(address, this._bootstrap, this._allChannels, this._tcpNoDelay), this._scheduler, (RateLimiter)new NoopRateLimiter(), this._idleTimeout, this._createChannelImmediately, this._maxPoolWaiterSize, (Clock)SystemClock.instance(), (LongTracker)NoopLongTracker.instance());
    }
}

