/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.client.stream.http2;

import com.linkedin.common.callback.Callback;
import com.linkedin.r2.message.Request;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.message.stream.StreamResponse;
import com.linkedin.r2.netty.common.NettyChannelAttributes;
import com.linkedin.r2.netty.common.NettyClientState;
import com.linkedin.r2.netty.handler.common.SslHandshakeTimingHandler;
import com.linkedin.r2.transport.common.bridge.common.RequestWithCallback;
import com.linkedin.r2.transport.common.bridge.common.TransportCallback;
import com.linkedin.r2.transport.common.bridge.common.TransportResponseImpl;
import com.linkedin.r2.transport.http.client.AbstractJmxManager;
import com.linkedin.r2.transport.http.client.AsyncPool;
import com.linkedin.r2.transport.http.client.AsyncPoolHandle;
import com.linkedin.r2.transport.http.client.TimeoutAsyncPoolHandle;
import com.linkedin.r2.transport.http.client.TimeoutTransportCallback;
import com.linkedin.r2.transport.http.client.common.ChannelPoolManager;
import com.linkedin.r2.transport.http.client.common.ErrorChannelFutureListener;
import com.linkedin.r2.transport.http.client.common.ssl.SslSessionValidator;
import com.linkedin.r2.transport.http.client.stream.AbstractNettyStreamClient;
import com.linkedin.r2.transport.http.common.HttpProtocolVersion;
import com.linkedin.r2.util.Cancellable;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class Http2NettyStreamClient
extends AbstractNettyStreamClient {
    public Http2NettyStreamClient(EventLoopGroup eventLoopGroup, ScheduledExecutorService scheduler, long requestTimeout, long shutdownTimeout, ExecutorService callbackExecutors, AbstractJmxManager jmxManager, ChannelPoolManager channelPoolManager, ChannelPoolManager sslChannelPoolManager) {
        super(eventLoopGroup, scheduler, requestTimeout, shutdownTimeout, callbackExecutors, jmxManager, channelPoolManager, sslChannelPoolManager);
    }

    @Override
    protected void doWriteRequestWithWireAttrHeaders(Request request, RequestContext requestContext, SocketAddress address, Map<String, String> wireAttrs, TimeoutTransportCallback<StreamResponse> callback, long requestTimeout) {
        AsyncPool<Channel> pool;
        try {
            pool = this.getChannelPoolManagerPerRequest(request).getPoolForAddress(address);
        }
        catch (IllegalStateException e) {
            Http2NettyStreamClient.errorResponse(callback, e);
            return;
        }
        requestContext.putLocalAttr("HTTP_PROTOCOL_VERSION", (Object)HttpProtocolVersion.HTTP_2);
        ChannelPoolGetCallback getCallback = new ChannelPoolGetCallback(pool, request, requestContext, callback, requestTimeout);
        Cancellable pendingGet = pool.get((Callback)getCallback);
        if (pendingGet != null) {
            callback.addTimeoutTask(() -> ((Cancellable)pendingGet).cancel());
        }
    }

    private class ChannelPoolGetCallback
    implements Callback<Channel> {
        private final AsyncPool<Channel> _pool;
        private final Request _request;
        private RequestContext _requestContext;
        private final TimeoutTransportCallback<StreamResponse> _callback;
        private final long _requestTimeout;

        ChannelPoolGetCallback(AsyncPool<Channel> pool, Request request, RequestContext requestContext, TimeoutTransportCallback<StreamResponse> callback, long requestTimeout) {
            this._pool = pool;
            this._request = request;
            this._requestContext = requestContext;
            this._callback = callback;
            this._requestTimeout = requestTimeout;
        }

        public void onSuccess(Channel channel) {
            NettyClientState state = (NettyClientState)((Object)Http2NettyStreamClient.this._state.get());
            if (state == NettyClientState.REQUESTS_STOPPING || state == NettyClientState.SHUTDOWN) {
                this._callback.onResponse(TransportResponseImpl.error((Throwable)new TimeoutException("Operation did not complete before shutdown")));
                this._pool.put((Object)channel);
                return;
            }
            SslSessionValidator sslSessionValidator = (SslSessionValidator)this._requestContext.getLocalAttr("REQUESTED_SSL_SESSION_VALIDATOR");
            channel.attr(NettyChannelAttributes.SSL_SESSION_VALIDATOR).set((Object)sslSessionValidator);
            TimeoutAsyncPoolHandle handle = new TimeoutAsyncPoolHandle(this._pool, Http2NettyStreamClient.this._scheduler, this._requestTimeout, TimeUnit.MILLISECONDS, (Object)channel);
            TransportCallback<StreamResponse> sslTimingCallback = SslHandshakeTimingHandler.getSslTimingCallback(channel, this._requestContext, this._callback);
            RequestWithCallback request = new RequestWithCallback(this._request, sslTimingCallback, (AsyncPoolHandle)handle);
            channel.writeAndFlush((Object)request).addListener((GenericFutureListener)new ErrorChannelFutureListener());
        }

        public void onError(Throwable e) {
            this._callback.onResponse(TransportResponseImpl.error((Throwable)e));
        }
    }
}

