/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.client.stream.http2;

import com.linkedin.util.ArgumentUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.util.AttributeKey;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Http2PipelinePropertyUtil {
    private static final Logger LOG = LoggerFactory.getLogger(Http2PipelinePropertyUtil.class);

    private Http2PipelinePropertyUtil() {
    }

    public static <T> T set(ChannelHandlerContext ctx, Http2Connection http2Connection, int streamId, AttributeKey<Http2Connection.PropertyKey> key, T value) {
        return (T)Http2PipelinePropertyUtil.doAction(ctx, http2Connection, streamId, key, (stream, propertyKey) -> stream.setProperty(propertyKey, value));
    }

    public static <T> T remove(ChannelHandlerContext ctx, Http2Connection http2Connection, int streamId, AttributeKey<Http2Connection.PropertyKey> key) {
        return (T)Http2PipelinePropertyUtil.doAction(ctx, http2Connection, streamId, key, Http2Stream::removeProperty);
    }

    public static <T> T get(ChannelHandlerContext ctx, Http2Connection http2Connection, int streamId, AttributeKey<Http2Connection.PropertyKey> key) {
        return (T)Http2PipelinePropertyUtil.doAction(ctx, http2Connection, streamId, key, Http2Stream::getProperty);
    }

    private static <T> T getKey(ChannelHandlerContext ctx, AttributeKey<T> key) {
        ArgumentUtil.notNull((Object)ctx, (String)"ctx");
        ArgumentUtil.notNull(key, (String)"key");
        return (T)ctx.channel().attr(key).get();
    }

    private static <T> T doAction(ChannelHandlerContext ctx, Http2Connection http2Connection, int streamId, AttributeKey<Http2Connection.PropertyKey> key, BiFunction<Http2Stream, Http2Connection.PropertyKey, T> function) {
        ArgumentUtil.notNull((Object)http2Connection, (String)"http2Connection");
        Http2Stream stream = http2Connection.stream(streamId);
        if (stream == null) {
            LOG.debug("Stream {} no longer exists", (Object)streamId);
            return null;
        }
        Http2Connection.PropertyKey propertyKey = Http2PipelinePropertyUtil.getKey(ctx, key);
        if (propertyKey == null) {
            LOG.debug("Property key {} is not valid", key);
            return null;
        }
        return function.apply(stream, propertyKey);
    }
}

