/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.client.stream.http2;

import com.linkedin.r2.message.Request;
import com.linkedin.r2.transport.common.bridge.common.RequestWithCallback;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import java.net.URI;

class Http2SchemeHandler
extends ChannelOutboundHandlerAdapter {
    private final String _scheme;

    public Http2SchemeHandler(String scheme) {
        this._scheme = scheme;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (!(msg instanceof RequestWithCallback)) {
            ctx.write(msg, promise);
            return;
        }
        Request request = ((RequestWithCallback)msg).request();
        URI uri = request.getURI();
        String scheme = uri.getScheme();
        if (!scheme.equalsIgnoreCase(this._scheme)) {
            ((RequestWithCallback)msg).handle().release();
            throw new IllegalStateException(String.format("Cannot switch scheme from %s to %s for %s", this._scheme, scheme, ctx.channel().remoteAddress()));
        }
        ctx.write(msg, promise);
    }
}

