/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.client.stream.http2;

import com.linkedin.r2.transport.http.client.stream.http2.Http2FrameListener;
import com.linkedin.r2.transport.http.client.stream.http2.Http2StreamCodec;
import io.netty.handler.codec.http2.AbstractHttp2ConnectionHandlerBuilder;
import io.netty.handler.codec.http2.DefaultHttp2ConnectionDecoder;
import io.netty.handler.codec.http2.DefaultHttp2ConnectionEncoder;
import io.netty.handler.codec.http2.DefaultHttp2FrameReader;
import io.netty.handler.codec.http2.DefaultHttp2FrameWriter;
import io.netty.handler.codec.http2.DefaultHttp2HeadersDecoder;
import io.netty.handler.codec.http2.DefaultHttp2LocalFlowController;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2FlowController;
import io.netty.handler.codec.http2.Http2FrameReader;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2HeadersDecoder;
import io.netty.handler.codec.http2.Http2InboundFrameLogger;
import io.netty.handler.codec.http2.Http2LifecycleManager;
import io.netty.handler.codec.http2.Http2OutboundFrameLogger;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.StreamBufferingEncoder;
import io.netty.util.internal.ObjectUtil;

class Http2StreamCodecBuilder
extends AbstractHttp2ConnectionHandlerBuilder<Http2StreamCodec, Http2StreamCodecBuilder> {
    private final long MAX_INITIAL_STREAM_WINDOW_SIZE = 0x800000L;
    private final boolean AUTO_REFILL_CONNECTION_WINDOW = true;
    private long _maxContentLength = -1L;
    private long _gracefulShutdownTimeoutMillis = -1L;
    private Http2Connection _connection = null;

    Http2StreamCodecBuilder() {
    }

    public Http2StreamCodecBuilder maxContentLength(long maxContentLength) {
        ObjectUtil.checkPositive((long)maxContentLength, (String)"maxContentLength");
        this._maxContentLength = maxContentLength;
        return (Http2StreamCodecBuilder)this.self();
    }

    public Http2StreamCodecBuilder gracefulShutdownTimeoutMillis(long gracefulShutdownTimeoutMillis) {
        ObjectUtil.checkPositive((long)gracefulShutdownTimeoutMillis, (String)"gracefulShutdownTimeoutMillis");
        this._gracefulShutdownTimeoutMillis = gracefulShutdownTimeoutMillis;
        return (Http2StreamCodecBuilder)this.self();
    }

    public Http2StreamCodecBuilder connection(Http2Connection connection) {
        ObjectUtil.checkNotNull((Object)connection, (String)"connection");
        this._connection = connection;
        return (Http2StreamCodecBuilder)this.self();
    }

    public Http2StreamCodec build() {
        ObjectUtil.checkNotNull((Object)this._connection, (String)"connection");
        DefaultHttp2HeadersDecoder headerDecoder = new DefaultHttp2HeadersDecoder(this.isValidateHeaders());
        DefaultHttp2FrameReader reader = new DefaultHttp2FrameReader((Http2HeadersDecoder)headerDecoder);
        DefaultHttp2FrameWriter writer = new DefaultHttp2FrameWriter(this.headerSensitivityDetector());
        if (this.frameLogger() != null) {
            reader = new Http2InboundFrameLogger((Http2FrameReader)reader, this.frameLogger());
            writer = new Http2OutboundFrameLogger((Http2FrameWriter)writer, this.frameLogger());
        }
        DefaultHttp2ConnectionEncoder encoder = new DefaultHttp2ConnectionEncoder(this._connection, (Http2FrameWriter)writer);
        boolean encoderEnforceMaxConcurrentStreams = this.encoderEnforceMaxConcurrentStreams();
        if (encoderEnforceMaxConcurrentStreams) {
            if (this._connection.isServer()) {
                encoder.close();
                reader.close();
                throw new IllegalArgumentException("encoderEnforceMaxConcurrentStreams: " + encoderEnforceMaxConcurrentStreams + " not supported for server");
            }
            encoder = new StreamBufferingEncoder((Http2ConnectionEncoder)encoder);
        }
        this._connection.local().flowController((Http2FlowController)new DefaultHttp2LocalFlowController(this._connection, 0.5f, true));
        DefaultHttp2ConnectionDecoder decoder = new DefaultHttp2ConnectionDecoder(this._connection, (Http2ConnectionEncoder)encoder, (Http2FrameReader)reader);
        super.codec((Http2ConnectionDecoder)decoder, (Http2ConnectionEncoder)encoder);
        return (Http2StreamCodec)super.build();
    }

    protected Http2StreamCodec build(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings) throws Exception {
        ObjectUtil.checkPositive((long)this._maxContentLength, (String)"maxContentLength");
        ObjectUtil.checkPositive((long)this._gracefulShutdownTimeoutMillis, (String)"gracefulShutdownTimeoutMillis");
        ObjectUtil.checkNotNull((Object)this._connection, (String)"connection");
        int initialWindowSize = (int)Math.min(0x800000L, this._maxContentLength);
        initialSettings.initialWindowSize(initialWindowSize);
        Http2StreamCodec codec = new Http2StreamCodec(decoder, encoder, initialSettings);
        super.frameListener((io.netty.handler.codec.http2.Http2FrameListener)new Http2FrameListener(this._connection, (Http2LifecycleManager)codec, this._maxContentLength, initialWindowSize));
        super.gracefulShutdownTimeoutMillis(this._gracefulShutdownTimeoutMillis);
        return codec;
    }
}

