/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.server;

import com.linkedin.r2.transport.http.server.HttpDispatcher;
import com.linkedin.r2.transport.http.server.HttpNettyServerPipelineInitializer;
import com.linkedin.r2.transport.http.server.HttpServer;
import com.linkedin.r2.util.NamedThreadFactory;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.ThreadFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;

class HttpNettyServer
implements HttpServer {
    private final int _port;
    private final int _threadPoolSize;
    private final HttpDispatcher _dispatcher;
    private final boolean _restOverStream;
    private final SSLContext _sslContext;
    private final SSLParameters _sslParameters;
    private final int _startupTimeoutMillis;
    private NioEventLoopGroup _bossGroup;
    private NioEventLoopGroup _workerGroup;
    private EventExecutorGroup _eventExecutors;

    public HttpNettyServer(int port, int threadPoolSize, HttpDispatcher dispatcher) {
        this(port, threadPoolSize, dispatcher, false);
    }

    public HttpNettyServer(int port, int threadPoolSize, HttpDispatcher dispatcher, SSLContext sslContext, SSLParameters sslParameters) {
        this(port, threadPoolSize, dispatcher, false, sslContext, sslParameters);
    }

    public HttpNettyServer(int port, int threadPoolSize, HttpDispatcher dispatcher, boolean restOverStream) {
        this(port, threadPoolSize, dispatcher, restOverStream, null, null);
    }

    public HttpNettyServer(int port, int threadPoolSize, HttpDispatcher dispatcher, boolean restOverStream, SSLContext sslContext, SSLParameters sslParameters) {
        this(port, threadPoolSize, dispatcher, restOverStream, sslContext, sslParameters, 10000);
    }

    public HttpNettyServer(int port, int threadPoolSize, HttpDispatcher dispatcher, boolean restOverStream, SSLContext sslContext, SSLParameters sslParameters, int startupTimeoutMillis) {
        this._port = port;
        this._threadPoolSize = threadPoolSize;
        this._dispatcher = dispatcher;
        this._restOverStream = restOverStream;
        this._sslContext = sslContext;
        this._sslParameters = sslParameters;
        this._startupTimeoutMillis = startupTimeoutMillis;
    }

    public void start() {
        this._eventExecutors = new DefaultEventExecutorGroup(this._threadPoolSize);
        this._bossGroup = new NioEventLoopGroup(1, (ThreadFactory)new NamedThreadFactory("R2 Nio Boss"));
        this._workerGroup = new NioEventLoopGroup(0, (ThreadFactory)new NamedThreadFactory("R2 Nio Worker"));
        HttpNettyServerPipelineInitializer pipelineInitializer = new HttpNettyServerPipelineInitializer(this._dispatcher, this._eventExecutors, this._sslContext, this._sslParameters, this._restOverStream);
        ServerBootstrap bootstrap = ((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)this._bossGroup, (EventLoopGroup)this._workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)pipelineInitializer);
        bootstrap.bind((SocketAddress)new InetSocketAddress(this._port)).awaitUninterruptibly((long)this._startupTimeoutMillis);
    }

    public void stop() {
        try {
            this._bossGroup.shutdownGracefully().sync();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this._workerGroup.shutdownGracefully().sync();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this._eventExecutors.shutdownGracefully().sync();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void waitForStop() throws InterruptedException {
        this._bossGroup.terminationFuture().await();
        this._workerGroup.terminationFuture().await();
        this._eventExecutors.terminationFuture().await();
    }
}

