/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.server;

import com.linkedin.r2.filter.FilterChain;
import com.linkedin.r2.filter.transport.FilterChainDispatcher;
import com.linkedin.r2.transport.common.bridge.server.TransportDispatcher;
import com.linkedin.r2.transport.http.server.HttpDispatcher;
import com.linkedin.r2.transport.http.server.HttpDispatcherFactory;
import com.linkedin.r2.transport.http.server.HttpNettyServer;
import com.linkedin.util.ArgumentUtil;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;

public class HttpNettyServerBuilder {
    public static final int DEFAULT_NETTY_HTTP_SERVER_PORT = 8080;
    public static final int DEFAULT_THREAD_POOL_SIZE = 256;
    private TransportDispatcher _transportDispatcher = null;
    private FilterChain _filters = null;
    private int _port = 8080;
    private int _threadPoolSize = 256;
    private boolean _restOverStream = false;
    private SSLContext _sslContext = null;
    private SSLParameters _sslParameters = null;

    public HttpNettyServerBuilder filters(FilterChain filters) {
        this._filters = filters;
        return this;
    }

    public HttpNettyServerBuilder port(int port) {
        this._port = port;
        return this;
    }

    public HttpNettyServerBuilder threadPoolSize(int threadPoolSize) {
        this._threadPoolSize = threadPoolSize;
        return this;
    }

    public HttpNettyServerBuilder transportDispatcher(TransportDispatcher dispatcher) {
        this._transportDispatcher = dispatcher;
        return this;
    }

    public HttpNettyServerBuilder _restOverStream(boolean restOverStream) {
        this._restOverStream = restOverStream;
        return this;
    }

    public HttpNettyServerBuilder sslContext(SSLContext sslContext) {
        this._sslContext = sslContext;
        return this;
    }

    public HttpNettyServerBuilder sslParameters(SSLParameters sslParameters) {
        this._sslParameters = sslParameters;
        return this;
    }

    public HttpNettyServer build() {
        this.validateParameters();
        FilterChainDispatcher filterDispatcher = new FilterChainDispatcher(this._transportDispatcher, this._filters);
        HttpDispatcher dispatcher = HttpDispatcherFactory.create((TransportDispatcher)filterDispatcher);
        return new HttpNettyServer(this._port, this._threadPoolSize, dispatcher, this._sslContext, this._sslParameters);
    }

    private void validateParameters() {
        ArgumentUtil.notNull((Object)this._transportDispatcher, (String)"transportDispatcher");
        ArgumentUtil.notNull((Object)this._filters, (String)"filters");
    }
}

