/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.server;

import com.linkedin.r2.netty.common.SslHandlerUtil;
import com.linkedin.r2.transport.http.server.HttpDispatcher;
import com.linkedin.r2.transport.http.server.PipelineRestHandler;
import com.linkedin.r2.transport.http.server.PipelineStreamHandler;
import com.linkedin.r2.transport.http.server.RAPServerCodec;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.EventExecutorGroup;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;

public class HttpNettyServerPipelineInitializer
extends ChannelInitializer<NioSocketChannel> {
    private final SSLContext _sslContext;
    private final SSLParameters _sslParameters;
    private final EventExecutorGroup _eventExecutors;
    private final boolean _restOverStream;
    private final HttpDispatcher _dispatcher;

    HttpNettyServerPipelineInitializer(HttpDispatcher dispatcher, EventExecutorGroup eventExecutors, SSLContext sslContext, SSLParameters sslParameters, boolean restOverStream) {
        this._dispatcher = dispatcher;
        this._sslContext = sslContext;
        this._sslParameters = sslParameters;
        this._eventExecutors = eventExecutors;
        this._restOverStream = restOverStream;
    }

    protected void initChannel(NioSocketChannel ch) throws Exception {
        SslHandlerUtil.validateSslParameters(this._sslContext, this._sslParameters);
        if (this._sslContext != null) {
            SslHandler sslHandler = SslHandlerUtil.getServerSslHandler(this._sslContext, this._sslParameters);
            ch.pipeline().addLast("sslHandler", (ChannelHandler)sslHandler);
        }
        ch.pipeline().addLast("decoder", (ChannelHandler)new HttpRequestDecoder());
        ch.pipeline().addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(0x100000));
        ch.pipeline().addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
        ch.pipeline().addLast("rapi", (ChannelHandler)new RAPServerCodec());
        SimpleChannelInboundHandler restHandler = this._restOverStream ? new PipelineStreamHandler(this._dispatcher) : new PipelineRestHandler(this._dispatcher);
        ch.pipeline().addLast(this._eventExecutors, "handler", (ChannelHandler)restHandler);
    }
}

