/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.server;

import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.message.rest.RestResponseBuilder;
import com.linkedin.r2.message.rest.RestStatus;
import com.linkedin.r2.transport.common.WireAttributeHelper;
import com.linkedin.r2.transport.common.bridge.common.TransportCallback;
import com.linkedin.r2.transport.common.bridge.common.TransportResponse;
import com.linkedin.r2.transport.common.bridge.common.TransportResponseImpl;
import com.linkedin.r2.transport.http.server.HttpDispatcher;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PipelineRestHandler
extends SimpleChannelInboundHandler<RestRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(PipelineRestHandler.class);
    private final HttpDispatcher _dispatcher;

    PipelineRestHandler(HttpDispatcher dispatcher) {
        this._dispatcher = dispatcher;
    }

    protected void channelRead0(ChannelHandlerContext ctx, RestRequest request) throws Exception {
        final Channel ch = ctx.channel();
        TransportCallback<RestResponse> writeResponseCallback = new TransportCallback<RestResponse>(){

            public void onResponse(TransportResponse<RestResponse> response) {
                RestResponseBuilder responseBuilder = response.hasError() ? new RestResponseBuilder(RestStatus.responseForError((int)RestStatus.INTERNAL_SERVER_ERROR, (Throwable)response.getError())) : new RestResponseBuilder((RestResponse)response.getResponse());
                ((RestResponseBuilder)responseBuilder.unsafeOverwriteHeaders(WireAttributeHelper.toWireAttributes((Map)response.getWireAttributes()))).build();
                ch.writeAndFlush((Object)responseBuilder.build());
            }
        };
        try {
            this._dispatcher.handleRequest(request, (TransportCallback)writeResponseCallback);
        }
        catch (Exception ex) {
            writeResponseCallback.onResponse(TransportResponseImpl.error((Throwable)ex, Collections.emptyMap()));
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        LOG.error("Exception caught on channel: " + ctx.channel().remoteAddress(), cause);
        ctx.close();
    }
}

