/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.server;

import com.linkedin.common.callback.Callback;
import com.linkedin.r2.message.Messages;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.message.rest.RestResponseBuilder;
import com.linkedin.r2.message.rest.RestStatus;
import com.linkedin.r2.message.stream.StreamResponse;
import com.linkedin.r2.transport.common.WireAttributeHelper;
import com.linkedin.r2.transport.common.bridge.common.TransportCallback;
import com.linkedin.r2.transport.common.bridge.common.TransportResponse;
import com.linkedin.r2.transport.common.bridge.common.TransportResponseImpl;
import com.linkedin.r2.transport.http.server.HttpDispatcher;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PipelineStreamHandler
extends SimpleChannelInboundHandler<RestRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(PipelineStreamHandler.class);
    private final HttpDispatcher _dispatcher;

    PipelineStreamHandler(HttpDispatcher dispatcher) {
        this._dispatcher = dispatcher;
    }

    private void writeError(Channel ch, TransportResponse<StreamResponse> response, Throwable ex) {
        RestResponseBuilder responseBuilder = (RestResponseBuilder)new RestResponseBuilder(RestStatus.responseForError((int)RestStatus.INTERNAL_SERVER_ERROR, (Throwable)ex)).unsafeOverwriteHeaders(WireAttributeHelper.toWireAttributes((Map)response.getWireAttributes()));
        ch.writeAndFlush((Object)responseBuilder.build());
    }

    private void writeResponse(Channel ch, TransportResponse<StreamResponse> response, RestResponse restResponse) {
        RestResponseBuilder responseBuilder = (RestResponseBuilder)restResponse.builder().unsafeOverwriteHeaders(WireAttributeHelper.toWireAttributes((Map)response.getWireAttributes()));
        ch.writeAndFlush((Object)responseBuilder.build());
    }

    protected void channelRead0(ChannelHandlerContext ctx, RestRequest request) throws Exception {
        final Channel ch = ctx.channel();
        TransportCallback<StreamResponse> writeResponseCallback = new TransportCallback<StreamResponse>(){

            public void onResponse(final TransportResponse<StreamResponse> response) {
                if (response.hasError()) {
                    PipelineStreamHandler.this.writeError(ch, (TransportResponse<StreamResponse>)response, response.getError());
                } else {
                    Messages.toRestResponse((StreamResponse)((StreamResponse)response.getResponse()), (Callback)new Callback<RestResponse>(){

                        public void onError(Throwable e) {
                            PipelineStreamHandler.this.writeError(ch, (TransportResponse<StreamResponse>)response, e);
                        }

                        public void onSuccess(RestResponse result) {
                            PipelineStreamHandler.this.writeResponse(ch, (TransportResponse<StreamResponse>)response, result);
                        }
                    });
                }
            }
        };
        try {
            this._dispatcher.handleRequest(Messages.toStreamRequest((RestRequest)request), (TransportCallback)writeResponseCallback);
        }
        catch (Exception ex) {
            writeResponseCallback.onResponse(TransportResponseImpl.error((Throwable)ex, Collections.emptyMap()));
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        LOG.error("Exception caught on channel: " + ctx.channel().remoteAddress(), cause);
        ctx.close();
    }
}

