/*
 * Decompiled with CFR 0.152.
 */
package io.activej.bytebuf;

final class ThreadLocalCharArray {
    private static final ThreadLocal<char[]> THREAD_LOCAL = ThreadLocal.withInitial(() -> new char[0]);

    private ThreadLocalCharArray() {
    }

    public static char[] ensure(int size) {
        char[] chars = THREAD_LOCAL.get();
        if (chars.length >= size) {
            return chars;
        }
        chars = new char[size + (size >>> 2)];
        THREAD_LOCAL.set(chars);
        return chars;
    }

    public static char[] ensure(char[] providedBuffer, int size) {
        if (providedBuffer.length >= size) {
            return providedBuffer;
        }
        return ThreadLocalCharArray.ensure(size);
    }
}

