/*
 * Decompiled with CFR 0.152.
 */
package io.activej.codegen;

import io.activej.codegen.BytecodeStorage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBytecodeStorage
implements BytecodeStorage {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final int DEFAULT_BUFFER_SIZE = 8192;

    protected abstract Optional<InputStream> getInputStream(String var1) throws IOException;

    protected abstract Optional<OutputStream> getOutputStream(String var1) throws IOException;

    @Override
    public final Optional<byte[]> loadBytecode(String className) {
        Optional<byte[]> optional;
        block10: {
            Optional<InputStream> maybeInputStream = this.getInputStream(className);
            if (!maybeInputStream.isPresent()) {
                return Optional.empty();
            }
            InputStream stream = maybeInputStream.get();
            try {
                int size;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buffer = new byte[8192];
                while ((size = stream.read(buffer)) != -1) {
                    baos.write(buffer, 0, size);
                }
                optional = Optional.of(baos.toByteArray());
                if (stream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    this.onLoadError(className, e);
                    return Optional.empty();
                }
            }
            stream.close();
        }
        return optional;
    }

    @Override
    public final void saveBytecode(String className, byte[] bytecode) {
        try {
            Optional<OutputStream> maybeOutputStream = this.getOutputStream(className);
            if (!maybeOutputStream.isPresent()) {
                return;
            }
            try (OutputStream outputStream = maybeOutputStream.get();){
                outputStream.write(bytecode);
            }
        }
        catch (IOException e) {
            this.onSaveError(className, bytecode, e);
        }
    }

    protected void onLoadError(String className, IOException e) {
        this.logger.warn("Could not load bytecode for class: {}", (Object)className, (Object)e);
    }

    protected void onSaveError(String className, byte[] bytecode, IOException e) {
        this.logger.warn("Could not save bytecode for class: {}", (Object)className, (Object)e);
    }
}

