/*
 * Decompiled with CFR 0.152.
 */
package io.activej.codegen;

import io.activej.codegen.ClassBuilder;
import io.activej.codegen.expression.Expression;
import io.activej.codegen.expression.Expressions;
import io.activej.codegen.expression.VarLocal;
import io.activej.codegen.util.Utils;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

public final class Context {
    private static final Set<Method> OBJECT_INSTANCE_METHODS = Arrays.stream(Object.class.getMethods()).filter(m -> !Modifier.isStatic(m.getModifiers())).map(Method::getMethod).collect(Collectors.toSet());
    private final ClassLoader classLoader;
    private final ClassBuilder<?> classBuilder;
    private final GeneratorAdapter g;
    private final Type selfType;
    private final Method method;
    private Set<Method> accessibleMethods;
    private final Map<Object, VarLocal> varLocals = new HashMap<Object, VarLocal>();

    public Context(ClassLoader classLoader, ClassBuilder<?> builder, GeneratorAdapter g, Type selfType, Method method) {
        this.classLoader = classLoader;
        this.classBuilder = builder;
        this.g = g;
        this.selfType = selfType;
        this.method = method;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public ClassBuilder<?> getClassBuilder() {
        return this.classBuilder;
    }

    public GeneratorAdapter getGeneratorAdapter() {
        return this.g;
    }

    public Type getSelfType() {
        return this.selfType;
    }

    public Class<?> getSuperclass() {
        return this.classBuilder.superclass;
    }

    public List<Class<?>> getInterfaces() {
        return this.classBuilder.interfaces;
    }

    public Map<String, Class<?>> getFields() {
        return this.classBuilder.fields;
    }

    public Map<Method, Expression> getMethods() {
        return this.classBuilder.methods;
    }

    public Set<Method> getAccessibleMethods() {
        if (this.accessibleMethods != null) {
            return this.accessibleMethods;
        }
        this.accessibleMethods = new HashSet<Method>(this.classBuilder.methods.keySet());
        for (Class<?> superclass = this.classBuilder.superclass; superclass != null; superclass = superclass.getSuperclass()) {
            for (java.lang.reflect.Method method : superclass.getDeclaredMethods()) {
                int modifiers = method.getModifiers();
                if (Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers) && !Modifier.isProtected(modifiers)) continue;
                this.accessibleMethods.add(Method.getMethod((java.lang.reflect.Method)method));
            }
        }
        return this.accessibleMethods;
    }

    public Map<Method, Expression> getStaticMethods() {
        return this.classBuilder.staticMethods;
    }

    public Method getMethod() {
        return this.method;
    }

    public VarLocal newLocal(Type type) {
        if (type == Type.VOID_TYPE) {
            return VarLocal.VAR_LOCAL_VOID;
        }
        int local = this.getGeneratorAdapter().newLocal(type);
        return new VarLocal(local);
    }

    public VarLocal ensureLocal(Object key, Expression expression) {
        VarLocal varLocal = this.varLocals.get(key);
        if (varLocal == null) {
            Type type = expression.load(this);
            if (type == Type.VOID_TYPE) {
                varLocal = VarLocal.VAR_LOCAL_VOID;
            } else {
                int local = this.getGeneratorAdapter().newLocal(type);
                varLocal = new VarLocal(local);
                this.g.storeLocal(local);
            }
            this.varLocals.put(key, varLocal);
        }
        return varLocal;
    }

    private SelfOrClass toSelfOrClass(Type type) {
        return type.equals((Object)this.getSelfType()) ? new SelfOrClass(this.classBuilder.superclass, this.classBuilder.interfaces) : new SelfOrClass(this.toJavaType(type), Collections.emptyList());
    }

    public Class<?> toJavaType(Type type) {
        if (type.equals((Object)this.getSelfType())) {
            throw new IllegalArgumentException();
        }
        int sort = type.getSort();
        if (sort == 1) {
            return Boolean.TYPE;
        }
        if (sort == 2) {
            return Character.TYPE;
        }
        if (sort == 3) {
            return Byte.TYPE;
        }
        if (sort == 4) {
            return Short.TYPE;
        }
        if (sort == 5) {
            return Integer.TYPE;
        }
        if (sort == 6) {
            return Float.TYPE;
        }
        if (sort == 7) {
            return Long.TYPE;
        }
        if (sort == 8) {
            return Double.TYPE;
        }
        if (sort == 0) {
            return Void.TYPE;
        }
        if (sort == 10) {
            try {
                return this.classLoader.loadClass(type.getClassName());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(String.format("No class %s in class loader", type.getClassName()), e);
            }
        }
        if (sort == 9) {
            Class result;
            if (type.equals((Object)Type.getType(Object[].class))) {
                result = Object[].class;
            } else {
                String className = type.getDescriptor().replace('/', '.');
                try {
                    result = Class.forName(className);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException(String.format("No class %s in Class.forName", className), e);
                }
            }
            return result;
        }
        throw new IllegalArgumentException(String.format("No Java type for %s", type.getClassName()));
    }

    public void cast(Type typeFrom, Type typeTo) {
        GeneratorAdapter g = this.getGeneratorAdapter();
        if (typeFrom.equals((Object)typeTo)) {
            return;
        }
        if (typeTo == Type.VOID_TYPE) {
            if (typeFrom.getSize() == 1) {
                g.pop();
            }
            if (typeFrom.getSize() == 2) {
                g.pop2();
            }
            return;
        }
        if (typeFrom == Type.VOID_TYPE) {
            throw new RuntimeException(String.format("Can't cast VOID_TYPE type to %s. %s", typeTo.getClassName(), Utils.exceptionInGeneratedClass(this)));
        }
        if (typeFrom.equals((Object)this.getSelfType())) {
            SelfOrClass fromSelfOrClass = this.toSelfOrClass(typeFrom);
            SelfOrClass toSelfOrClass = this.toSelfOrClass(typeTo);
            if (toSelfOrClass.isAssignableFrom(fromSelfOrClass)) {
                return;
            }
            throw new RuntimeException(String.format("Can't cast self %s type to %s, %s", typeFrom.getClassName(), typeTo.getClassName(), Utils.exceptionInGeneratedClass(this)));
        }
        if (!typeFrom.equals((Object)this.getSelfType()) && !typeTo.equals((Object)this.getSelfType()) && this.toJavaType(typeTo).isAssignableFrom(this.toJavaType(typeFrom))) {
            return;
        }
        if (typeTo.equals((Object)Type.getType(Object.class)) && Utils.isPrimitiveType(typeFrom)) {
            g.box(typeFrom);
            return;
        }
        if (!Utils.isPrimitiveType(typeFrom) && !Utils.isWrapperType(typeFrom) && Utils.isPrimitiveType(typeTo)) {
            Type typeToWrapped = Utils.wrap(typeTo);
            g.checkCast(typeToWrapped);
            typeFrom = typeToWrapped;
        }
        if ((Utils.isPrimitiveType(typeFrom) || Utils.isWrapperType(typeFrom)) && (Utils.isPrimitiveType(typeTo) || Utils.isWrapperType(typeTo))) {
            Type targetTypePrimitive;
            Type type = targetTypePrimitive = Utils.isPrimitiveType(typeTo) ? typeTo : Utils.unwrap(typeTo);
            if (Utils.isWrapperType(typeFrom)) {
                g.invokeVirtual(typeFrom, Utils.toPrimitive(typeTo));
                return;
            }
            assert (Utils.isPrimitiveType(typeFrom));
            if (Utils.isValidCast(typeFrom, targetTypePrimitive)) {
                g.cast(typeFrom, targetTypePrimitive);
            }
            if (Utils.isWrapperType(typeTo)) {
                g.valueOf(targetTypePrimitive);
            }
            return;
        }
        g.checkCast(typeTo);
    }

    public Type invoke(Expression owner, String methodName, Expression ... arguments) {
        return this.invoke(owner, methodName, Arrays.asList(arguments));
    }

    public Type invoke(Expression owner, String methodName, List<Expression> arguments) {
        Type ownerType = owner.load(this);
        Type[] argumentTypes = new Type[arguments.size()];
        for (int i = 0; i < arguments.size(); ++i) {
            Expression argument = arguments.get(i);
            argumentTypes[i] = argument.load(this);
        }
        return this.invoke(ownerType, methodName, argumentTypes);
    }

    public Type invoke(Type ownerType, String methodName, Type ... argumentTypes) {
        Method foundMethod;
        SelfOrClass[] arguments = (SelfOrClass[])Stream.of(argumentTypes).map(this::toSelfOrClass).toArray(SelfOrClass[]::new);
        if (ownerType.equals((Object)this.getSelfType())) {
            foundMethod = this.findMethod(this.getAccessibleMethods().stream(), methodName, arguments);
            if (foundMethod == null) {
                throw new IllegalArgumentException("Method not found: " + ownerType.getClassName() + '#' + methodName + Arrays.stream(arguments).map(SelfOrClass::toString).collect(Collectors.joining(",", "(", ")")));
            }
            this.g.invokeVirtual(ownerType, foundMethod);
        } else {
            Class<?> javaOwnerType = this.toJavaType(ownerType);
            foundMethod = this.findMethod(Arrays.stream(javaOwnerType.getMethods()).filter(m -> !Modifier.isStatic(m.getModifiers())).map(Method::getMethod), methodName, arguments);
            if (foundMethod == null) {
                throw new IllegalArgumentException("Method not found: " + ownerType.getClassName() + '#' + methodName + Arrays.stream(arguments).map(SelfOrClass::toString).collect(Collectors.joining(",", "(", ")")));
            }
            if (javaOwnerType.isInterface()) {
                this.g.invokeInterface(ownerType, foundMethod);
            } else {
                this.g.invokeVirtual(ownerType, foundMethod);
            }
        }
        return foundMethod.getReturnType();
    }

    public Type invokeStatic(Type ownerType, String methodName, Expression ... arguments) {
        return this.invokeStatic(ownerType, methodName, Arrays.asList(arguments));
    }

    public Type invokeStatic(Type ownerType, String methodName, List<Expression> arguments) {
        Type[] argumentTypes = new Type[arguments.size()];
        for (int i = 0; i < arguments.size(); ++i) {
            Expression argument = arguments.get(i);
            argumentTypes[i] = argument.load(this);
        }
        return this.invokeStatic(ownerType, methodName, argumentTypes);
    }

    public Type invokeStatic(Type ownerType, String methodName, Type ... argumentTypes) {
        SelfOrClass[] arguments = (SelfOrClass[])Stream.of(argumentTypes).map(this::toSelfOrClass).toArray(SelfOrClass[]::new);
        Method foundMethod = ownerType.equals((Object)this.getSelfType()) ? this.findMethod(this.getStaticMethods().keySet().stream(), methodName, arguments) : this.findMethod(Arrays.stream(this.toJavaType(ownerType).getMethods()).filter(m -> Modifier.isStatic(m.getModifiers())).map(Method::getMethod), methodName, arguments);
        if (foundMethod == null) {
            throw new IllegalArgumentException("Static method not found: " + ownerType.getClassName() + '.' + methodName + Arrays.stream(arguments).map(SelfOrClass::toString).collect(Collectors.joining(",", "(", ")")));
        }
        this.g.invokeStatic(ownerType, foundMethod);
        return foundMethod.getReturnType();
    }

    public Type invokeConstructor(Type ownerType, Expression ... arguments) {
        return this.invokeConstructor(ownerType, Arrays.asList(arguments));
    }

    public Type invokeConstructor(Type ownerType, List<Expression> arguments) {
        this.g.newInstance(ownerType);
        this.g.dup();
        Type[] argumentTypes = new Type[arguments.size()];
        for (int i = 0; i < arguments.size(); ++i) {
            argumentTypes[i] = arguments.get(i).load(this);
        }
        return this.invokeConstructor(ownerType, argumentTypes);
    }

    public Type invokeConstructor(Type ownerType, Type ... argumentTypes) {
        if (ownerType.equals((Object)this.getSelfType())) {
            throw new IllegalArgumentException();
        }
        SelfOrClass[] arguments = (SelfOrClass[])Stream.of(argumentTypes).map(this::toSelfOrClass).toArray(SelfOrClass[]::new);
        Method foundMethod = this.findMethod(Arrays.stream(this.toJavaType(ownerType).getConstructors()).map(Method::getMethod), "<init>", arguments);
        if (foundMethod == null) {
            throw new IllegalArgumentException("Constructor not found:" + ownerType.getClassName() + Arrays.stream(arguments).map(SelfOrClass::toString).collect(Collectors.joining(",", "(", ")")));
        }
        this.g.invokeConstructor(ownerType, foundMethod);
        return ownerType;
    }

    public Type invokeSuperConstructor(List<Expression> arguments) {
        this.g.loadThis();
        Type[] argumentTypes = new Type[arguments.size()];
        for (int i = 0; i < arguments.size(); ++i) {
            argumentTypes[i] = arguments.get(i).load(this);
        }
        SelfOrClass[] argumentClasses = (SelfOrClass[])Stream.of(argumentTypes).map(this::toSelfOrClass).toArray(SelfOrClass[]::new);
        Method foundMethod = this.findMethod(Arrays.stream(this.classBuilder.superclass.getDeclaredConstructors()).map(Method::getMethod), "<init>", argumentClasses);
        if (foundMethod == null) {
            throw new IllegalArgumentException("Parent constructor not found: " + this.classBuilder.superclass.getSimpleName() + " with arguments " + Arrays.stream(argumentClasses).map(SelfOrClass::toString).collect(Collectors.joining(",", "(", ")")));
        }
        this.g.invokeConstructor(Type.getType(this.classBuilder.superclass), foundMethod);
        for (String field : this.classBuilder.fieldExpressions.keySet()) {
            if (this.classBuilder.fieldsStatic.contains(field)) continue;
            Expression expression = this.classBuilder.fieldExpressions.get(field);
            Expressions.set(Expressions.property(Expressions.self(), field), expression).load(this);
        }
        return Type.VOID_TYPE;
    }

    public Type invokeSuperMethod(String methodName, Expression[] arguments) {
        return this.invokeSuperMethod(methodName, Arrays.asList(arguments));
    }

    public Type invokeSuperMethod(String methodName, List<Expression> arguments) {
        this.g.loadThis();
        Type[] argumentTypes = new Type[arguments.size()];
        for (int i = 0; i < arguments.size(); ++i) {
            argumentTypes[i] = arguments.get(i).load(this);
        }
        SelfOrClass[] argumentClasses = (SelfOrClass[])Stream.of(argumentTypes).map(this::toSelfOrClass).toArray(SelfOrClass[]::new);
        Method foundMethod = this.findMethod(this.getAccessibleMethods().stream(), methodName, argumentClasses);
        if (foundMethod == null) {
            throw new IllegalArgumentException("Parent method of " + this.classBuilder.superclass.getSimpleName() + " with name'" + methodName + "' and arguments " + Arrays.stream(argumentClasses).map(SelfOrClass::toString).collect(Collectors.joining(",", "(", ")")) + " not found");
        }
        String typeName = Type.getType(this.classBuilder.superclass).getInternalName();
        this.g.visitMethodInsn(183, typeName, methodName, this.method.getDescriptor(), false);
        return foundMethod.getReturnType();
    }

    @Nullable
    private Method findMethod(Stream<Method> methods, String name, SelfOrClass[] arguments) {
        Set methodSet = methods.collect(Collectors.toSet());
        methodSet.addAll(OBJECT_INSTANCE_METHODS);
        Method foundMethod = null;
        SelfOrClass[] foundMethodArguments = null;
        for (Method method : methodSet) {
            SelfOrClass[] methodArguments;
            if (!name.equals(method.getName()) || !Context.isAssignable(methodArguments = (SelfOrClass[])Stream.of(method.getArgumentTypes()).map(this::toSelfOrClass).toArray(SelfOrClass[]::new), arguments)) continue;
            if (foundMethod == null) {
                foundMethod = method;
                foundMethodArguments = methodArguments;
                continue;
            }
            if (Context.isAssignable(foundMethodArguments, methodArguments)) {
                foundMethod = method;
                foundMethodArguments = methodArguments;
                continue;
            }
            if (Context.isAssignable(methodArguments, foundMethodArguments)) continue;
            throw new IllegalArgumentException("Ambiguous method: " + method + " " + Arrays.toString(arguments));
        }
        return foundMethod;
    }

    private static boolean isAssignable(SelfOrClass[] to, SelfOrClass[] from) {
        if (to.length != from.length) {
            return false;
        }
        return IntStream.range(0, from.length).allMatch(i -> to[i].isAssignableFrom(from[i]));
    }

    private static final class SelfOrClass {
        final Class<?> implementation;
        final List<Class<?>> interfaces;

        private SelfOrClass(Class<?> implementation, List<Class<?>> interfaces) {
            this.implementation = implementation;
            this.interfaces = interfaces;
        }

        boolean isAssignableFrom(Class<?> cls) {
            if (this.implementation.isAssignableFrom(cls)) {
                return true;
            }
            for (Class<?> anInterface : this.interfaces) {
                if (!anInterface.isAssignableFrom(cls)) continue;
                return true;
            }
            return false;
        }

        boolean isAssignableFrom(SelfOrClass selfOrClass) {
            if (!selfOrClass.isSelf()) {
                return this.isAssignableFrom(selfOrClass.implementation);
            }
            if (this.isSelf()) {
                assert (this.implementation == selfOrClass.implementation);
                assert (this.interfaces.equals(selfOrClass.interfaces));
                return true;
            }
            if (this.implementation.isAssignableFrom(selfOrClass.implementation)) {
                return true;
            }
            for (Class<?> anInterface : selfOrClass.interfaces) {
                if (!this.implementation.isAssignableFrom(anInterface)) continue;
                return true;
            }
            return false;
        }

        boolean isSelf() {
            return !this.interfaces.isEmpty();
        }

        public String toString() {
            if (this.interfaces.isEmpty()) {
                return this.implementation.getName();
            }
            StringBuilder sb = new StringBuilder(this.implementation.getName());
            for (Class<?> anInterface : this.interfaces) {
                sb.append('|').append(anInterface.getName());
            }
            return sb.toString();
        }
    }
}

