/*
 * Decompiled with CFR 0.152.
 */
package io.activej.codegen;

import io.activej.codegen.BytecodeStorage;
import io.activej.codegen.ClassBuilder;
import io.activej.codegen.ClassKey;
import io.activej.codegen.DefiningClassLoaderMBean;
import io.activej.codegen.GeneratedBytecode;
import io.activej.codegen.util.Utils;
import io.activej.codegen.util.WithInitializer;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DefiningClassLoader
extends ClassLoader
implements DefiningClassLoaderMBean,
WithInitializer<DefiningClassLoader> {
    public static final Path DEFAULT_DEBUG_OUTPUT_DIR = Utils.getPathSetting(DefiningClassLoader.class, "debugOutputDir", null);
    private final Map<String, Class<?>> definedClasses = new ConcurrentHashMap();
    private final Map<ClassKey<?>, AtomicReference<Class<?>>> cachedClasses = new ConcurrentHashMap();
    @Nullable
    private BytecodeStorage bytecodeStorage;
    private Path debugOutputDir = DEFAULT_DEBUG_OUTPUT_DIR;

    private DefiningClassLoader() {
    }

    private DefiningClassLoader(ClassLoader parent) {
        super(parent);
    }

    public static DefiningClassLoader create() {
        return new DefiningClassLoader();
    }

    public static DefiningClassLoader create(ClassLoader parent) {
        return new DefiningClassLoader(parent);
    }

    public DefiningClassLoader withBytecodeStorage(BytecodeStorage bytecodeStorage) {
        this.bytecodeStorage = bytecodeStorage;
        return this;
    }

    public DefiningClassLoader withDebugOutputDir(Path debugOutputDir) {
        this.debugOutputDir = debugOutputDir;
        return this;
    }

    public Class<?> defineClass(String className, byte[] bytecode) {
        Class<?> aClass = super.defineClass(className, bytecode, 0, bytecode.length);
        this.definedClasses.put(className, aClass);
        if (this.debugOutputDir != null) {
            try (FileOutputStream fos = new FileOutputStream(this.debugOutputDir.resolve(className + ".class").toFile());){
                fos.write(bytecode);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return aClass;
    }

    @NotNull
    public <T> Class<T> ensureClass(String className, Supplier<ClassBuilder<T>> classBuilder) {
        return this.ensureClass(className, (ClassLoader cl, String s) -> ((ClassBuilder)classBuilder.get()).toBytecode((ClassLoader)cl, (String)s));
    }

    @NotNull
    public <T> Class<T> ensureClass(ClassKey<T> key, Supplier<ClassBuilder<T>> classBuilder) {
        return this.ensureClass(key, (ClassLoader classLoader) -> ((ClassBuilder)classBuilder.get()).toBytecode((ClassLoader)classLoader));
    }

    @NotNull
    public <T> T ensureClassAndCreateInstance(String className, Supplier<ClassBuilder<T>> classBuilder, Object ... arguments) {
        return DefiningClassLoader.createInstance(this.ensureClass(className, classBuilder), arguments);
    }

    @NotNull
    public <T> T ensureClassAndCreateInstance(ClassKey<T> key, Supplier<ClassBuilder<T>> classBuilder, Object ... arguments) {
        Class<T> aClass = this.ensureClass(key, classBuilder);
        return DefiningClassLoader.createInstance(aClass, arguments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public <T> Class<T> ensureClass(String className, BiFunction<ClassLoader, String, GeneratedBytecode> bytecodeBuilder) {
        try {
            return this.loadClass(className, false);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Object object = this.getClassLoadingLock(className);
            synchronized (object) {
                byte[] bytecode;
                if (this.bytecodeStorage != null && (bytecode = (byte[])this.bytecodeStorage.loadBytecode(className).orElse(null)) != null) {
                    return this.defineClass(className, bytecode);
                }
                GeneratedBytecode generatedBytecode = bytecodeBuilder.apply(this, className);
                Class<?> aClass = generatedBytecode.defineClass(this);
                if (this.bytecodeStorage != null) {
                    this.bytecodeStorage.saveBytecode(className, generatedBytecode.getBytecode());
                }
                return aClass;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public <T> Class<T> ensureClass(ClassKey<T> key, Function<ClassLoader, GeneratedBytecode> bytecodeBuilder) {
        AtomicReference reference = this.cachedClasses.computeIfAbsent(key, k -> new AtomicReference());
        Class<?> aClass = (Class<?>)reference.get();
        if (aClass == null) {
            AtomicReference atomicReference = reference;
            synchronized (atomicReference) {
                aClass = (Class)reference.get();
                if (aClass == null) {
                    GeneratedBytecode generatedBytecode = bytecodeBuilder.apply(this);
                    aClass = generatedBytecode.defineClass(this);
                    reference.set(aClass);
                }
            }
        }
        return aClass;
    }

    @NotNull
    public <T> T ensureClassAndCreateInstance(ClassKey<T> key, Function<ClassLoader, GeneratedBytecode> bytecodeBuilder, Object ... arguments) {
        Class<T> aClass = this.ensureClass(key, bytecodeBuilder);
        return DefiningClassLoader.createInstance(aClass, arguments);
    }

    @NotNull
    static <T> T createInstance(Class<T> aClass, Object[] arguments) {
        try {
            return aClass.getConstructor((Class[])Arrays.stream(arguments).map(Object::getClass).toArray(Class[]::new)).newInstance(arguments);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public Class<?> getCachedClass(@NotNull ClassKey<?> key) {
        return Optional.ofNullable(this.cachedClasses.get(key)).map(AtomicReference::get).orElse(null);
    }

    @Override
    public int getDefinedClassesCount() {
        return this.definedClasses.size();
    }

    @Override
    public Map<String, Long> getDefinedClassesCountByType() {
        return this.definedClasses.values().stream().map(aClass -> aClass.getSuperclass() == Object.class && aClass.getInterfaces().length != 0 ? aClass.getInterfaces()[0] : aClass.getSuperclass()).map(Class::getName).collect(Collectors.groupingBy(UnaryOperator.identity(), Collectors.counting()));
    }

    @Override
    public int getCachedClassesCount() {
        return this.cachedClasses.size();
    }

    @Override
    public Map<String, Long> getCachedClassesCountByType() {
        return this.cachedClasses.keySet().stream().map(key -> key.getKeyClass().getName()).collect(Collectors.groupingBy(UnaryOperator.identity(), Collectors.counting()));
    }

    public String toString() {
        return "{classes=" + this.cachedClasses.size() + ", byType=" + this.getCachedClassesCountByType() + '}';
    }
}

