/*
 * Decompiled with CFR 0.152.
 */
package io.activej.codegen;

import io.activej.codegen.AbstractBytecodeStorage;
import io.activej.codegen.util.WithInitializer;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Optional;

public final class FileBytecodeStorage
extends AbstractBytecodeStorage
implements WithInitializer<FileBytecodeStorage> {
    private static final String CLASS_FILE_EXTENSION = ".class";
    private final Path storageDir;

    private FileBytecodeStorage(Path storageDir) {
        this.storageDir = storageDir;
    }

    public static FileBytecodeStorage create(Path storageDir) {
        return new FileBytecodeStorage(storageDir);
    }

    @Override
    protected Optional<InputStream> getInputStream(String className) {
        try {
            FileInputStream fileInputStream = new FileInputStream(this.storageDir.resolve(className + CLASS_FILE_EXTENSION).toFile());
            return Optional.of(fileInputStream);
        }
        catch (FileNotFoundException ignored) {
            return Optional.empty();
        }
    }

    @Override
    protected Optional<OutputStream> getOutputStream(String className) throws IOException {
        return Optional.of(new FileOutputStream(this.storageDir.resolve(className + CLASS_FILE_EXTENSION).toFile()));
    }
}

