/*
 * Decompiled with CFR 0.152.
 */
package io.activej.codegen.expression;

import io.activej.codegen.Context;
import io.activej.codegen.expression.Expression;
import java.util.List;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;

final class ExpressionBooleanOr
implements Expression {
    private final List<Expression> expressions;

    ExpressionBooleanOr(List<Expression> expressions) {
        this.expressions = expressions;
    }

    @Override
    public Type load(Context ctx) {
        GeneratorAdapter g = ctx.getGeneratorAdapter();
        Label exit = new Label();
        Label labelTrue = new Label();
        for (Expression predicate : this.expressions) {
            Type type = predicate.load(ctx);
            if (type != Type.BOOLEAN_TYPE) {
                throw new IllegalArgumentException();
            }
            g.ifZCmp(154, labelTrue);
        }
        g.push(false);
        g.goTo(exit);
        g.mark(labelTrue);
        g.push(true);
        g.mark(exit);
        return Type.BOOLEAN_TYPE;
    }
}

