/*
 * Decompiled with CFR 0.152.
 */
package io.activej.codegen.expression;

import io.activej.codegen.Context;
import io.activej.codegen.expression.Expression;
import io.activej.codegen.operation.CompareOperation;
import io.activej.codegen.util.Utils;
import java.util.Objects;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

final class ExpressionCmp
implements Expression {
    private final Expression left;
    private final Expression right;
    private final CompareOperation operation;

    ExpressionCmp(CompareOperation operation, Expression left, Expression right) {
        this.left = left;
        this.right = right;
        this.operation = operation;
    }

    @Override
    public Type load(Context ctx) {
        Type rightType;
        GeneratorAdapter g = ctx.getGeneratorAdapter();
        Label labelTrue = new Label();
        Label labelExit = new Label();
        Type leftType = this.left.load(ctx);
        if (!Objects.equals(leftType, rightType = this.right.load(ctx))) {
            throw new IllegalArgumentException("Types of compared values should match");
        }
        if (Utils.isPrimitiveType(leftType)) {
            g.ifCmp(leftType, this.operation.opCode, labelTrue);
        } else if (this.operation == CompareOperation.EQ || this.operation == CompareOperation.NE) {
            g.invokeVirtual(leftType, new Method("equals", Type.BOOLEAN_TYPE, new Type[]{Type.getType(Object.class)}));
            g.push(this.operation == CompareOperation.EQ);
            g.ifCmp(Type.BOOLEAN_TYPE, 153, labelTrue);
        } else {
            g.invokeVirtual(leftType, new Method("compareTo", Type.INT_TYPE, new Type[]{Type.getType(Object.class)}));
            if (this.operation == CompareOperation.LT) {
                g.ifZCmp(155, labelTrue);
            } else if (this.operation == CompareOperation.GT) {
                g.ifZCmp(157, labelTrue);
            } else if (this.operation == CompareOperation.LE) {
                g.ifZCmp(158, labelTrue);
            } else if (this.operation == CompareOperation.GE) {
                g.ifZCmp(156, labelTrue);
            }
        }
        g.push(false);
        g.goTo(labelExit);
        g.mark(labelTrue);
        g.push(true);
        g.mark(labelExit);
        return Type.BOOLEAN_TYPE;
    }
}

