/*
 * Decompiled with CFR 0.152.
 */
package io.activej.codegen.expression;

import io.activej.codegen.Context;
import io.activej.codegen.expression.Expression;
import io.activej.codegen.util.Utils;
import java.util.List;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

public final class ExpressionConcat
implements Expression {
    private final List<Expression> arguments;

    private ExpressionConcat(List<Expression> arguments) {
        this.arguments = arguments;
    }

    public static ExpressionConcat create(List<Expression> arguments) {
        return new ExpressionConcat(arguments);
    }

    @Override
    public Type load(Context ctx) {
        GeneratorAdapter g = ctx.getGeneratorAdapter();
        g.newInstance(Type.getType(StringBuilder.class));
        g.dup();
        g.invokeConstructor(Type.getType(StringBuilder.class), Method.getMethod((String)"void <init> ()"));
        for (Expression expression : this.arguments) {
            g.dup();
            Type type = expression.load(ctx);
            if (Utils.isPrimitiveType(type)) {
                g.invokeStatic(Utils.wrap(type), new Method("toString", Type.getType(String.class), new Type[]{type}));
            } else {
                Label nullLabel = new Label();
                Label afterToString = new Label();
                g.dup();
                g.ifNull(nullLabel);
                g.invokeVirtual(type, Method.getMethod((String)"String toString()"));
                g.goTo(afterToString);
                g.mark(nullLabel);
                g.pop();
                g.push("null");
                g.mark(afterToString);
            }
            g.invokeVirtual(Type.getType(StringBuilder.class), Method.getMethod((String)"StringBuilder append(String)"));
            g.pop();
        }
        g.invokeVirtual(Type.getType(StringBuilder.class), Method.getMethod((String)"String toString()"));
        return Type.getType(String.class);
    }
}

