/*
 * Decompiled with CFR 0.152.
 */
package io.activej.codegen.expression;

import io.activej.codegen.Context;
import io.activej.codegen.expression.Expression;
import io.activej.codegen.util.Primitives;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;

public final class ExpressionConstant
implements Expression {
    private static final AtomicInteger COUNTER = new AtomicInteger();
    @NotNull
    private final Object value;
    @Nullable
    private final Class<?> cls;
    private final int id = COUNTER.incrementAndGet();

    ExpressionConstant(@NotNull Object value) {
        this.value = value;
        this.cls = null;
    }

    ExpressionConstant(@NotNull Object value, Class<?> cls) {
        if (!cls.isInstance(value)) {
            throw new IllegalArgumentException(value + " is not an instance of " + cls);
        }
        this.value = value;
        this.cls = cls;
    }

    @NotNull
    public Object getValue() {
        return this.value;
    }

    @Override
    public Type load(Context ctx) {
        GeneratorAdapter g = ctx.getGeneratorAdapter();
        Type type = this.cls == null ? (this.value instanceof String ? Type.getType(String.class) : (this.value instanceof Type ? (Type)this.value : Type.getType(Primitives.unwrap(this.value.getClass())))) : Type.getType(this.cls);
        if (this.value instanceof Byte) {
            g.push((int)((Byte)this.value).byteValue());
        } else if (this.value instanceof Short) {
            g.push((int)((Short)this.value).shortValue());
        } else if (this.value instanceof Integer) {
            g.push(((Integer)this.value).intValue());
        } else if (this.value instanceof Long) {
            g.push(((Long)this.value).longValue());
        } else if (this.value instanceof Float) {
            g.push(((Float)this.value).floatValue());
        } else if (this.value instanceof Double) {
            g.push(((Double)this.value).doubleValue());
        } else if (this.value instanceof Boolean) {
            g.push(((Boolean)this.value).booleanValue());
        } else if (this.value instanceof Character) {
            g.push((int)((Character)this.value).charValue());
        } else if (this.value instanceof String) {
            g.push((String)this.value);
        } else if (this.value instanceof Type) {
            g.push((Type)this.value);
        } else if (this.value instanceof Enum) {
            g.getStatic(type, ((Enum)this.value).name(), type);
        } else {
            String field = "$STATIC_CONSTANT_" + this.getId();
            Class<?> aClass = this.cls == null ? this.value.getClass() : this.cls;
            ctx.getClassBuilder().withStaticFinalField(field, aClass, this);
            g.getStatic(ctx.getSelfType(), field, Type.getType(aClass));
        }
        return type;
    }

    public int getId() {
        return this.id;
    }

    public boolean isJvmPrimitive() {
        return this.value.getClass() == String.class || Primitives.isWrapperType(this.value.getClass());
    }
}

