/*
 * Decompiled with CFR 0.152.
 */
package io.activej.codegen.expression;

import io.activej.codegen.Context;
import io.activej.codegen.expression.Expression;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;

final class ExpressionLoop
implements Expression {
    private final Expression condition;
    private final Expression body;

    ExpressionLoop(Expression condition, Expression body) {
        this.condition = condition;
        this.body = body;
    }

    @Override
    public Type load(Context ctx) {
        GeneratorAdapter g = ctx.getGeneratorAdapter();
        Label labelLoop = new Label();
        Label labelExit = new Label();
        g.mark(labelLoop);
        Type conditionType = this.condition.load(ctx);
        if (conditionType != Type.BOOLEAN_TYPE) {
            throw new IllegalArgumentException("Condition must return boolean");
        }
        g.push(false);
        g.ifCmp(Type.BOOLEAN_TYPE, 153, labelExit);
        Type bodyType = this.body.load(ctx);
        if (bodyType.getSize() == 1) {
            g.pop();
        }
        if (bodyType.getSize() == 2) {
            g.pop2();
        }
        g.goTo(labelLoop);
        g.mark(labelExit);
        return Type.VOID_TYPE;
    }
}

