/*
 * Decompiled with CFR 0.152.
 */
package io.activej.codegen.expression;

import io.activej.codegen.Context;
import io.activej.codegen.expression.Variable;
import io.activej.codegen.util.Utils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;

final class ExpressionStaticField
implements Variable {
    @Nullable
    private final Class<?> owner;
    private final String name;

    ExpressionStaticField(@Nullable Class<?> owner, String name) {
        this.owner = owner;
        this.name = name;
    }

    @Override
    public Type load(Context ctx) {
        GeneratorAdapter g = ctx.getGeneratorAdapter();
        return this.findField(ctx, (ownerType, fieldType) -> g.getStatic(ownerType, this.name, fieldType));
    }

    @Override
    public Object beginStore(Context ctx) {
        return null;
    }

    @Override
    public void store(Context ctx, Object storeContext, Type type) {
        GeneratorAdapter g = ctx.getGeneratorAdapter();
        this.findField(ctx, (ownerType, fieldType) -> g.putStatic(ownerType, this.name, fieldType));
    }

    private Type findField(Context ctx, BiConsumer<Type, Type> action) {
        Type fieldType;
        Type ownerType;
        if (this.owner != null) {
            Field javaField;
            try {
                Class<?> ownerJavaType = ctx.toJavaType(Type.getType(this.owner));
                javaField = ownerJavaType.getField(this.name);
            }
            catch (NoSuchFieldException ignored) {
                throw new RuntimeException(String.format("No static field %s.%s %s", this.owner.getName(), this.name, Utils.exceptionInGeneratedClass(ctx)));
            }
            if (!Modifier.isPublic(javaField.getModifiers()) || !Modifier.isStatic(javaField.getModifiers())) {
                throw new RuntimeException(String.format("No static field or setter for class %s for field \"%s\". %s ", this.owner.getName(), this.name, Utils.exceptionInGeneratedClass(ctx)));
            }
            ownerType = Type.getType(this.owner);
            fieldType = Type.getType(javaField.getType());
        } else {
            ownerType = ctx.getSelfType();
            fieldType = Type.getType(ctx.getFields().get(this.name));
        }
        action.accept(ownerType, fieldType);
        return fieldType;
    }
}

