/*
 * Decompiled with CFR 0.152.
 */
package io.activej.codegen.expression;

import io.activej.codegen.Context;
import io.activej.codegen.expression.Expression;
import io.activej.codegen.expression.Variable;
import io.activej.codegen.util.Primitives;
import io.activej.codegen.util.Utils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

final class Property
implements Variable {
    private final Expression owner;
    private final String property;

    Property(@NotNull Expression owner, @NotNull String property) {
        this.owner = owner;
        this.property = property;
    }

    @Override
    public Type load(Context ctx) {
        Type ownerType = this.owner.load(ctx);
        return Property.loadPropertyOrGetter(ctx, ownerType, this.property);
    }

    @Override
    public Object beginStore(Context ctx) {
        return this.owner.load(ctx);
    }

    @Override
    public void store(Context ctx, Object storeContext, Type type) {
        Property.setProperty(ctx, (Type)storeContext, this.property, type);
    }

    public static void setProperty(Context ctx, Type ownerType, String property, Type valueType) {
        GeneratorAdapter g = ctx.getGeneratorAdapter();
        Class<?> valueClass = ctx.toJavaType(valueType);
        if (ctx.getSelfType().equals((Object)ownerType)) {
            Class<?> propertyClass = ctx.getFields().get(property);
            if (propertyClass == null) {
                throw new RuntimeException(String.format("No property \"%s\" in generated class %s. %s", property, ctx.getSelfType().getClassName(), Utils.exceptionInGeneratedClass(ctx)));
            }
            Type propertyType = Type.getType(propertyClass);
            ctx.cast(valueType, propertyType);
            g.putField(ownerType, property, propertyType);
            return;
        }
        Class<?> argumentClass = ctx.toJavaType(ownerType);
        try {
            Field javaProperty = argumentClass.getField(property);
            if (Modifier.isPublic(javaProperty.getModifiers())) {
                Type propertyType = Type.getType(javaProperty.getType());
                ctx.cast(valueType, propertyType);
                g.putField(ownerType, property, propertyType);
                return;
            }
        }
        catch (NoSuchFieldException javaProperty) {
            // empty catch block
        }
        java.lang.reflect.Method javaSetter = Property.tryFindSetter(argumentClass, property, valueClass);
        if (javaSetter == null && Primitives.isWrapperType(valueClass)) {
            javaSetter = Property.tryFindSetter(argumentClass, property, Primitives.unwrap(valueClass));
        }
        if (javaSetter == null && valueClass.isPrimitive()) {
            javaSetter = Property.tryFindSetter(argumentClass, property, Primitives.wrap(valueClass));
        }
        if (javaSetter == null) {
            javaSetter = Property.tryFindSetter(argumentClass, property);
        }
        if (javaSetter != null) {
            Type fieldType = Type.getType(javaSetter.getParameterTypes()[0]);
            ctx.cast(valueType, fieldType);
            Utils.invokeVirtualOrInterface(g, argumentClass, Method.getMethod((java.lang.reflect.Method)javaSetter));
            Type returnType = Type.getType(javaSetter.getReturnType());
            if (returnType.getSize() == 1) {
                g.pop();
            } else if (returnType.getSize() == 2) {
                g.pop2();
            }
            return;
        }
        throw new RuntimeException(String.format("No public property or setter for class %s for property \"%s\". %s ", ownerType.getClassName(), property, Utils.exceptionInGeneratedClass(ctx)));
    }

    @Nullable
    private static java.lang.reflect.Method tryFindSetter(Class<?> argumentClass, String property, Class<?> valueClass) {
        java.lang.reflect.Method m = null;
        try {
            m = argumentClass.getDeclaredMethod(property, valueClass);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (m == null && property.length() >= 1) {
            try {
                m = argumentClass.getDeclaredMethod("set" + Character.toUpperCase(property.charAt(0)) + property.substring(1), valueClass);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return m;
    }

    @Nullable
    private static java.lang.reflect.Method tryFindSetter(Class<?> argumentClass, String property) {
        String setterName = "set" + Character.toUpperCase(property.charAt(0)) + property.substring(1);
        for (java.lang.reflect.Method method : argumentClass.getDeclaredMethods()) {
            if (method.getParameterTypes().length != 1 || !method.getName().equals(property) && !method.getName().equals(setterName)) continue;
            return method;
        }
        return null;
    }

    public static Type loadPropertyOrGetter(Context ctx, Type ownerType, String property) {
        return Property.loadPropertyOrGetter(ctx, ownerType, property, true);
    }

    public static Type typeOfPropertyOrGetter(Context ctx, Type ownerType, String property) {
        return Property.loadPropertyOrGetter(ctx, ownerType, property, false);
    }

    private static Type loadPropertyOrGetter(Context ctx, Type ownerType, String property, boolean load) {
        GeneratorAdapter g;
        GeneratorAdapter generatorAdapter = g = load ? ctx.getGeneratorAdapter() : null;
        if (ownerType.equals((Object)ctx.getSelfType())) {
            Class<?> thisPropertyClass = ctx.getFields().get(property);
            if (thisPropertyClass != null) {
                Type resultType = Type.getType(thisPropertyClass);
                if (g != null) {
                    g.getField(ownerType, property, resultType);
                }
                return resultType;
            }
            throw new RuntimeException(String.format("No public property or getter for class %s for property \"%s\". %s", ownerType.getClassName(), property, Utils.exceptionInGeneratedClass(ctx)));
        }
        Class<?> argumentClass = ctx.toJavaType(ownerType);
        try {
            Field javaProperty = argumentClass.getField(property);
            if (Modifier.isPublic(javaProperty.getModifiers()) && !Modifier.isStatic(javaProperty.getModifiers())) {
                Type resultType = Type.getType(javaProperty.getType());
                if (g != null) {
                    g.getField(ownerType, property, resultType);
                }
                return resultType;
            }
        }
        catch (NoSuchFieldException javaProperty) {
            // empty catch block
        }
        java.lang.reflect.Method m = null;
        try {
            m = argumentClass.getDeclaredMethod(property, new Class[0]);
        }
        catch (NoSuchMethodException resultType) {
            // empty catch block
        }
        if (m == null && property.length() >= 1) {
            try {
                m = argumentClass.getDeclaredMethod("get" + Character.toUpperCase(property.charAt(0)) + property.substring(1), new Class[0]);
            }
            catch (NoSuchMethodException resultType) {
                // empty catch block
            }
        }
        if (m != null) {
            Type resultType = Type.getType(m.getReturnType());
            if (g != null) {
                Utils.invokeVirtualOrInterface(g, argumentClass, Method.getMethod((java.lang.reflect.Method)m));
            }
            return resultType;
        }
        throw new RuntimeException(String.format("No public property or getter for class %s for property \"%s\". %s", ownerType.getClassName(), property, Utils.exceptionInGeneratedClass(ctx)));
    }
}

