/*
 * Decompiled with CFR 0.152.
 */
package io.activej.record;

import io.activej.codegen.ClassBuilder;
import io.activej.codegen.ClassKey;
import io.activej.codegen.DefiningClassLoader;
import io.activej.codegen.expression.Expression;
import io.activej.codegen.expression.ExpressionComparator;
import io.activej.codegen.expression.Expressions;
import io.activej.codegen.expression.Variable;
import io.activej.codegen.util.WithInitializer;
import io.activej.record.Record;
import io.activej.record.RecordFactory;
import io.activej.record.RecordGetter;
import io.activej.record.RecordSetter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RecordScheme
implements WithInitializer<RecordScheme> {
    private RecordFactory factory;
    private RecordGetter<?>[] recordGetters;
    private RecordSetter<?>[] recordSetters;
    @Nullable
    private Comparator<Record> comparator;
    private final HashMap<String, RecordGetter<?>> recordGettersMap = new HashMap();
    private final HashMap<String, RecordSetter<?>> recordSettersMap = new HashMap();
    private final LinkedHashMap<String, Type> fieldTypes = new LinkedHashMap();
    private final LinkedHashMap<String, Integer> fieldIndices = new LinkedHashMap();
    private Type[] types = new Type[0];
    private final HashMap<String, String> classFields = new HashMap();
    String[] fields = new String[0];
    @Nullable
    private List<String> hashCodeEqualsFields;
    @Nullable
    private List<String> comparedFields;
    @NotNull
    private final DefiningClassLoader classLoader;
    private Class<? extends Record> generatedClass;

    private RecordScheme(@NotNull DefiningClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public static RecordScheme create() {
        return new RecordScheme(DefiningClassLoader.create());
    }

    public static RecordScheme create(@NotNull DefiningClassLoader classLoader) {
        return new RecordScheme(classLoader);
    }

    public RecordScheme withField(@NotNull String field, @NotNull Type type) {
        this.addField(field, type);
        return this;
    }

    public RecordScheme withHashCodeEqualsFields(List<String> hashCodeEqualsFields) {
        if (this.factory != null) {
            throw new IllegalStateException("Already initialized");
        }
        RecordScheme.checkUnique(hashCodeEqualsFields);
        this.hashCodeEqualsFields = hashCodeEqualsFields;
        return this;
    }

    public RecordScheme withHashCodeEqualsFields(String ... hashCodeEqualsFields) {
        return this.withHashCodeEqualsFields(Arrays.asList(hashCodeEqualsFields));
    }

    public RecordScheme withComparator(List<String> comparedFields) {
        if (this.factory != null) {
            throw new IllegalStateException("Already initialized");
        }
        RecordScheme.checkUnique(comparedFields);
        this.comparedFields = comparedFields;
        return this;
    }

    public RecordScheme withComparator(String ... comparedFields) {
        return this.withComparator(Arrays.asList(comparedFields));
    }

    public void addField(@NotNull String field, @NotNull Type type) {
        String classField;
        if (this.factory != null) {
            throw new IllegalStateException("Already initialized");
        }
        if (this.fieldTypes.containsKey(field)) {
            throw new IllegalArgumentException("Duplicate field");
        }
        this.fieldTypes.put(field, type);
        this.fields = Arrays.copyOf(this.fields, this.fields.length + 1);
        this.fields[this.fields.length - 1] = field;
        this.types = Arrays.copyOf(this.types, this.types.length + 1);
        this.types[this.types.length - 1] = type;
        this.fieldIndices.put(field, this.fieldIndices.size());
        char[] chars = (Character.isJavaIdentifierStart(field.charAt(0)) ? field : "_" + field).toCharArray();
        for (int i = 1; i < chars.length; ++i) {
            if (Character.isJavaIdentifierPart(chars[i])) continue;
            chars[i] = 95;
        }
        String sanitized = new String(chars);
        int i = 1;
        while (true) {
            String string = classField = i == 1 ? sanitized : sanitized + i;
            if (!this.classFields.containsKey(classField)) break;
            ++i;
        }
        this.classFields.put(field, classField);
    }

    public void addFields(Map<String, Class<?>> types) {
        for (Map.Entry<String, Class<?>> entry : types.entrySet()) {
            this.addField(entry.getKey(), entry.getValue());
        }
    }

    public Record record() {
        return this.factory.create();
    }

    public Comparator<Record> recordComparator() {
        if (this.factory == null) {
            throw new IllegalStateException("Not yet initialized");
        }
        if (this.comparator == null) {
            throw new IllegalStateException("Compared fields were not specified");
        }
        return this.comparator;
    }

    public Record recordOfArray(Object ... values) {
        Record record = this.record();
        record.setArray(values);
        return record;
    }

    public Record recordOfMap(Map<String, Object> values) {
        Record record = this.record();
        record.setMap(values);
        return record;
    }

    @NotNull
    public DefiningClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Class<? extends Record> getRecordClass() {
        this.build();
        return this.generatedClass;
    }

    public String getClassField(String field) {
        return this.classFields.get(field);
    }

    public Variable property(Expression record, String field) {
        return Expressions.property(record, this.getClassField(field));
    }

    public List<String> getFields() {
        return new ArrayList<String>(this.fieldTypes.keySet());
    }

    public String getField(int index) {
        return this.fields[index];
    }

    public Type getFieldType(String field) {
        return this.fieldTypes.get(field);
    }

    public Type getFieldType(int field) {
        return this.types[field];
    }

    public int getFieldIndex(String field) {
        return this.fieldIndices.get(field);
    }

    public int size() {
        return this.fields.length;
    }

    public RecordScheme build() {
        if (this.generatedClass == null) {
            this.doEnsureBuild();
        }
        return this;
    }

    private synchronized void doEnsureBuild() {
        Collection<String> hashCodeEqualsFields;
        Set<String> missing;
        if (this.hashCodeEqualsFields != null) {
            missing = this.getMissingFields(this.hashCodeEqualsFields);
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing some fields to generate 'hashCode' and 'equals' methods: " + missing);
            }
            hashCodeEqualsFields = this.hashCodeEqualsFields;
        } else {
            hashCodeEqualsFields = this.fieldTypes.keySet();
        }
        this.generatedClass = this.classLoader.ensureClass(ClassKey.of(Record.class, this), () -> ClassBuilder.create(Record.class, new Class[0]).withConstructor(Arrays.asList(RecordScheme.class), Expressions.superConstructor(Expressions.arg(0))).withMethod("hashCode", Expressions.hash(hashCodeEqualsFields.stream().map(this::getClassField).map(f -> Expressions.property(Expressions.self(), f)).collect(Collectors.toList()))).withMethod("equals", Expressions.equalsImpl(hashCodeEqualsFields.stream().map(this::getClassField).collect(Collectors.toList()))).withInitializer(b -> {
            for (Map.Entry<String, Type> entry : this.fieldTypes.entrySet()) {
                Type type = entry.getValue();
                b.withField(this.getClassField(entry.getKey()), type instanceof Class ? (Class)type : Object.class);
            }
        }));
        this.recordGetters = new RecordGetter[this.size()];
        this.recordSetters = new RecordSetter[this.size()];
        for (Map.Entry entry : this.fieldTypes.entrySet()) {
            RecordSetter recordSetter;
            RecordGetter recordGetter;
            String field = (String)entry.getKey();
            Type fieldType = (Type)entry.getValue();
            Variable property = this.property(Expressions.cast(Expressions.arg(0), this.generatedClass), field);
            this.recordGetters[this.recordGettersMap.size()] = recordGetter = this.classLoader.ensureClassAndCreateInstance(ClassKey.of(RecordGetter.class, this, field), () -> ClassBuilder.create(RecordGetter.class, new Class[0]).withMethod("get", property).withInitializer(cb -> {
                if (fieldType == Byte.TYPE || fieldType == Short.TYPE || fieldType == Integer.TYPE || fieldType == Long.TYPE || fieldType == Float.TYPE || fieldType == Double.TYPE || fieldType == Byte.class || fieldType == Short.class || fieldType == Integer.class || fieldType == Long.class || fieldType == Float.class || fieldType == Double.class) {
                    cb.withMethod("getInt", property);
                    cb.withMethod("getLong", property);
                    cb.withMethod("getFloat", property);
                    cb.withMethod("getDouble", property);
                }
            }).withMethod("getScheme", Expressions.value(this)).withMethod("getField", Expressions.value(field)).withMethod("getType", Expressions.value(fieldType, Type.class)), new Object[0]);
            this.recordGettersMap.put(field, recordGetter);
            Expression set = Expressions.set(property, Expressions.arg(1));
            this.recordSetters[this.recordSettersMap.size()] = recordSetter = this.classLoader.ensureClassAndCreateInstance(ClassKey.of(RecordSetter.class, this, field), () -> ClassBuilder.create(RecordSetter.class, new Class[0]).withMethod("set", set).withInitializer(cb -> {
                if (fieldType == Byte.TYPE || fieldType == Short.TYPE || fieldType == Integer.TYPE || fieldType == Long.TYPE || fieldType == Float.TYPE || fieldType == Double.TYPE || fieldType == Byte.class || fieldType == Short.class || fieldType == Integer.class || fieldType == Long.class || fieldType == Float.class || fieldType == Double.class) {
                    cb.withMethod("setInt", set);
                    cb.withMethod("setLong", set);
                    cb.withMethod("setFloat", set);
                    cb.withMethod("setDouble", set);
                }
            }).withMethod("getScheme", Expressions.value(this)).withMethod("getField", Expressions.value(field)).withMethod("getType", Expressions.value(fieldType, Type.class)), new Object[0]);
            this.recordSettersMap.put(field, recordSetter);
        }
        if (this.comparedFields != null) {
            missing = this.getMissingFields(this.comparedFields);
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing some fields to be compared: " + missing);
            }
            ExpressionComparator expressionComparator = ExpressionComparator.create();
            for (String comparedField : this.comparedFields) {
                String classField = this.classFields.get(comparedField);
                expressionComparator.with(ExpressionComparator.leftProperty(this.generatedClass, classField), ExpressionComparator.rightProperty(this.generatedClass, classField));
            }
            this.comparator = ClassBuilder.create(Comparator.class, new Class[0]).withMethod("compare", expressionComparator).defineClassAndCreateInstance(this.classLoader, new Object[0]);
        }
        this.factory = this.classLoader.ensureClassAndCreateInstance(ClassKey.of(RecordFactory.class, this), () -> ClassBuilder.create(RecordFactory.class, new Class[0]).withStaticFinalField("SCHEME", RecordScheme.class, Expressions.value(this)).withMethod("create", Record.class, Arrays.asList(new Class[0]), Expressions.constructor(this.generatedClass, Expressions.staticField("SCHEME"))), new Object[0]);
    }

    private Set<String> getMissingFields(List<String> fields) {
        return fields.stream().filter(field -> !this.fieldTypes.containsKey(field)).collect(Collectors.toSet());
    }

    private static void checkUnique(List<String> fields) {
        if (new HashSet<String>(fields).size() != fields.size()) {
            throw new IllegalArgumentException("Fields should be unique");
        }
    }

    public <T> RecordGetter<T> getter(String field) {
        return this.recordGettersMap.get(field);
    }

    public <T> RecordGetter<T> getter(int field) {
        return this.recordGetters[field];
    }

    public <T> T get(Record record, String field) {
        return this.getter(field).get(record);
    }

    public <T> T get(Record record, int field) {
        return this.getter(field).get(record);
    }

    public int getInt(Record record, String field) {
        return this.getter(field).getInt(record);
    }

    public int getInt(Record record, int field) {
        return this.getter(field).getInt(record);
    }

    public long getLong(Record record, String field) {
        return this.getter(field).getLong(record);
    }

    public long getLong(Record record, int field) {
        return this.getter(field).getLong(record);
    }

    public float getFloat(Record record, String field) {
        return this.getter(field).getFloat(record);
    }

    public float getFloat(Record record, int field) {
        return this.getter(field).getFloat(record);
    }

    public double getDouble(Record record, String field) {
        return this.getter(field).getDouble(record);
    }

    public double getDouble(Record record, int field) {
        return this.getter(field).getDouble(record);
    }

    public <T> RecordSetter<T> setter(String field) {
        return this.recordSettersMap.get(field);
    }

    public <T> RecordSetter<T> setter(int field) {
        return this.recordSetters[field];
    }

    public <T> void set(Record record, String field, T value) {
        this.setter(field).set(record, value);
    }

    public <T> void set(Record record, int field, T value) {
        this.setter(field).set(record, value);
    }

    public void setInt(Record record, String field, int value) {
        this.setter(field).setInt(record, value);
    }

    public void setInt(Record record, int field, int value) {
        this.setter(field).setInt(record, value);
    }

    public void setLong(Record record, String field, long value) {
        this.setter(field).setLong(record, value);
    }

    public void setLong(Record record, int field, long value) {
        this.setter(field).setLong(record, value);
    }

    public void setFloat(Record record, String field, float value) {
        this.setter(field).setFloat(record, value);
    }

    public void setFloat(Record record, int field, float value) {
        this.setter(field).setFloat(record, value);
    }

    public void setDouble(Record record, String field, double value) {
        this.setter(field).setDouble(record, value);
    }

    public void setDouble(Record record, int field, double value) {
        this.setter(field).setDouble(record, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecordScheme scheme = (RecordScheme)o;
        return Arrays.equals(this.fields, scheme.fields) && Arrays.equals(this.types, scheme.types);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.fields);
        result = 31 * result + Arrays.hashCode(this.types);
        return result;
    }

    public String toString() {
        return this.fieldTypes.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (entry.getValue() instanceof Class ? ((Class)entry.getValue()).getSimpleName() : entry.getValue())).collect(Collectors.joining(", ", "{", "}"));
    }
}

